/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.NumericLiteral;
import org.sonar.iac.arm.tree.api.ObjectExpression;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.impl.json.ArrayExpressionImpl;
import org.sonar.iac.arm.tree.impl.json.BooleanLiteralImpl;
import org.sonar.iac.arm.tree.impl.json.IdentifierImpl;
import org.sonar.iac.arm.tree.impl.json.NullLiteralImpl;
import org.sonar.iac.arm.tree.impl.json.NumericLiteralImpl;
import org.sonar.iac.arm.tree.impl.json.ObjectExpressionImpl;
import org.sonar.iac.arm.tree.impl.json.PropertyImpl;
import org.sonar.iac.arm.tree.impl.json.StringLiteralImpl;
import org.sonar.iac.common.api.tree.HasProperties;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.extension.BasicTextPointer;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.SequenceTree;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

public class ArmJsonBaseConverter {
    @Nullable
    protected final InputFileContext inputFileContext;

    public ArmJsonBaseConverter(@Nullable InputFileContext inputFileContext) {
        this.inputFileContext = inputFileContext;
    }

    public StringLiteral toStringLiteralOrNull(YamlTree tree, String key) {
        return PropertyUtils.get((Tree)tree, key::equalsIgnoreCase).map(this::toStringLiteral).orElse(null);
    }

    public StringLiteral toStringLiteralOrException(YamlTree tree, String key) {
        return PropertyUtils.get((Tree)tree, key::equalsIgnoreCase).map(this::toStringLiteral).orElseThrow(() -> this.missingMandatoryAttributeError(tree, key));
    }

    private StringLiteral toStringLiteral(PropertyTree property) {
        ScalarTree value = this.toDoubleQuoteScalarTree(property);
        return new StringLiteralImpl(value.value(), value.metadata());
    }

    public StringLiteral toNestedStringLiteralOrNull(YamlTree tree, String parentKey, String childKey) {
        return PropertyUtils.get((Tree)tree, parentKey).map(m -> this.extractPropertyOrNull((PropertyTree)m, childKey)).orElse(null);
    }

    public Identifier toIdentifier(YamlTree tree) {
        if (!(tree instanceof ScalarTree)) {
            throw this.convertError(tree, Identifier.class.getSimpleName(), ScalarTree.class.getSimpleName());
        }
        ScalarTree scalarTree = (ScalarTree)tree;
        return new IdentifierImpl(scalarTree.value(), scalarTree.metadata());
    }

    private ScalarTree toDoubleQuoteScalarTree(PropertyTree property) {
        if (!(property.value() instanceof ScalarTree)) {
            throw this.convertError(property, StringLiteral.class.getSimpleName(), ScalarTree.class.getSimpleName());
        }
        ScalarTree value = (ScalarTree)property.value();
        if (value.style() != ScalarTree.Style.DOUBLE_QUOTED) {
            throw this.convertError(property, value, StringLiteral.class.getSimpleName(), "ScalarTree.Style.DOUBLE_QUOTED");
        }
        return value;
    }

    public NumericLiteral toNumericLiteralOrNull(YamlTree tree, String key) {
        return PropertyUtils.get((Tree)tree, key::equalsIgnoreCase).map(this::toNumericLiteral).orElse(null);
    }

    private NumericLiteral toNumericLiteral(PropertyTree property) {
        if (!(property.value() instanceof ScalarTree)) {
            throw this.convertError(property, NumericLiteral.class.getSimpleName(), ScalarTree.class.getSimpleName());
        }
        ScalarTree value = (ScalarTree)property.value();
        if (value.style() != ScalarTree.Style.PLAIN) {
            throw this.convertError(property, value, NumericLiteral.class.getSimpleName(), "ScalarTree.Style.PLAIN");
        }
        try {
            Double.parseDouble(value.value());
            return new NumericLiteralImpl(value.value(), value.metadata());
        }
        catch (NumberFormatException e) {
            throw ParseException.createParseException("Failed to parse float value '" + value.value(), this.inputFileContext, new BasicTextPointer(value.textRange()));
        }
    }

    private ObjectExpression toObjectExpression(MappingTree tree) {
        ArrayList<Property> properties = new ArrayList<Property>();
        tree.elements().forEach(tupleTree -> {
            Identifier key = this.toIdentifier(tupleTree.key());
            Expression value = this.toExpression(tupleTree.value());
            properties.add(new PropertyImpl(key, value));
        });
        return new ObjectExpressionImpl(properties, tree.textRange());
    }

    public ArrayExpression toArrayExpressionOrNull(YamlTree tree, String key) {
        return PropertyUtils.get((Tree)tree, key::equalsIgnoreCase).map(this::toArrayExpression).orElse(null);
    }

    private ArrayExpression toArrayExpression(PropertyTree property) {
        if (!(property.value() instanceof SequenceTree)) {
            throw this.convertError(property, ArrayExpression.class.getSimpleName(), SequenceTree.class.getSimpleName());
        }
        return this.toArrayExpression((SequenceTree)property.value());
    }

    private ArrayExpression toArrayExpression(SequenceTree tree) {
        return new ArrayExpressionImpl(tree.metadata(), tree.elements().stream().map(this::toExpression).toList());
    }

    public Expression toExpressionOrNull(TupleTree tree, String key) {
        return PropertyUtils.get((Tree)tree.value(), key::equalsIgnoreCase).map(this::toExpression).orElse(null);
    }

    private Expression toExpression(PropertyTree tree) {
        return this.toExpression((YamlTree)tree.value());
    }

    public Expression toExpression(YamlTree tree) {
        if (tree instanceof SequenceTree) {
            SequenceTree sequence = (SequenceTree)tree;
            return this.toArrayExpression(sequence);
        }
        if (tree instanceof MappingTree) {
            MappingTree mapping = (MappingTree)tree;
            return this.toObjectExpression(mapping);
        }
        if (tree instanceof ScalarTree) {
            ScalarTree scalar = (ScalarTree)tree;
            return this.toLiteralExpression(scalar);
        }
        throw ParseException.createParseException("Couldn't convert to Expression, unsupported class " + tree.getClass().getSimpleName(), this.inputFileContext, new BasicTextPointer(tree.metadata().textRange()));
    }

    public Expression toLiteralExpression(ScalarTree tree) {
        if (tree.style() == ScalarTree.Style.PLAIN) {
            if ("null".equals(tree.value())) {
                return new NullLiteralImpl(tree.metadata());
            }
            if ("true".equals(tree.value()) || "false".equals(tree.value())) {
                return new BooleanLiteralImpl("true".equals(tree.value()), tree.metadata());
            }
            try {
                Double.parseDouble(tree.value());
                return new NumericLiteralImpl(tree.value(), tree.metadata());
            }
            catch (NumberFormatException e) {
                throw ParseException.createParseException("Failed to parse plain value '" + tree.value() + "'", this.inputFileContext, new BasicTextPointer(tree.metadata().textRange()));
            }
        }
        if (tree.style() == ScalarTree.Style.DOUBLE_QUOTED) {
            return new StringLiteralImpl(tree.value(), tree.metadata());
        }
        throw ParseException.createParseException("Unsupported ScalarTree style: " + tree.style().name(), this.inputFileContext, new BasicTextPointer(tree.metadata().textRange()));
    }

    protected List<Property> toProperties(Tree tree) {
        if (!(tree instanceof HasProperties)) {
            throw ParseException.createParseException("Couldn't convert properties: expecting object of class '" + tree.getClass().getSimpleName() + "' to implement HasProperties", this.inputFileContext, new BasicTextPointer(tree.textRange()));
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (PropertyTree propertyTree : ((HasProperties)((Object)tree)).properties()) {
            Identifier key = this.toIdentifier((YamlTree)propertyTree.key());
            Expression value = this.toExpression((YamlTree)propertyTree.value());
            properties.add(new PropertyImpl(key, value));
        }
        return properties;
    }

    @CheckForNull
    private StringLiteral extractPropertyOrNull(PropertyTree property, String name) {
        return PropertyUtils.get(property.value(), name::equalsIgnoreCase).map(this::toStringLiteral).orElse(null);
    }

    protected Stream<TupleTree> extractMappingToTupleTreeOnField(MappingTree document, String fieldName) {
        return document.elements().stream().filter(this.filterOnField(fieldName)).map(TupleTree::value).filter(MappingTree.class::isInstance).map(MappingTree.class::cast).map(MappingTree::elements).flatMap(Collection::stream);
    }

    protected Predicate<TupleTree> filterOnField(String field) {
        return tupleTree -> {
            ScalarTree scalar;
            YamlTree patt10146$temp = tupleTree.key();
            return patt10146$temp instanceof ScalarTree && field.equalsIgnoreCase((scalar = (ScalarTree)patt10146$temp).value());
        };
    }

    protected ParseException missingMandatoryAttributeError(YamlTree tree, String key) {
        return ParseException.createParseException("Missing mandatory attribute '" + key + "'", this.inputFileContext, new BasicTextPointer(tree.metadata().textRange()));
    }

    private ParseException convertError(PropertyTree property, String targetType, String expectedType) {
        YamlTree value = (YamlTree)property.value();
        String errorMessage = ArmJsonBaseConverter.convertErrorMessage(property.key(), targetType, expectedType, value.getClass().getSimpleName());
        return ParseException.createParseException(errorMessage, this.inputFileContext, new BasicTextPointer(value.textRange()));
    }

    private ParseException convertError(Tree tree, String targetType, String expectedType) {
        String errorMessage = ArmJsonBaseConverter.convertErrorMessage(tree, targetType, expectedType, tree.getClass().getSimpleName());
        return ParseException.createParseException(errorMessage, this.inputFileContext, new BasicTextPointer(tree.textRange()));
    }

    private ParseException convertError(PropertyTree property, ScalarTree value, String targetType, String expectedStyle) {
        String errorMessage = ArmJsonBaseConverter.convertErrorMessage(property.key(), targetType, expectedStyle, value.style().name());
        return ParseException.createParseException(errorMessage, this.inputFileContext, new BasicTextPointer(value.textRange()));
    }

    private static String convertErrorMessage(Tree objectToConvert, String targetType, String expectedValue, String valueFound) {
        String toConvert = TextUtils.getValue(objectToConvert).orElse(objectToConvert.toString());
        return "Couldn't convert '" + toConvert + "' into " + targetType + ": expecting " + expectedValue + ", got " + valueFound + " instead";
    }
}

