/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualArray;
import org.sonar.iac.arm.checkdsl.ContextualObject;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.tree.ArmTreeUtils;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.ParameterDeclaration;
import org.sonar.iac.arm.tree.api.ParameterType;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checkdsl.ContextualTree;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6656")
public class SecureValuesExposureCheck
extends AbstractArmResourceCheck {
    private static final String MESSAGE = "Change this code to not use an outer expression evaluation scope in nested templates.";
    private static final String SECONDARY_MESSAGE = "This secure parameter is leaked through the deployment history.";
    private static final String RESOURCES_PROP_NAME = "resources";

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Resources/deployments", SecureValuesExposureCheck::checkSecureParametersInNestedTemplates);
    }

    private static void checkSecureParametersInNestedTemplates(ContextualResource resource) {
        Map<String, ParameterDeclaration> sensitiveParameters = SecureValuesExposureCheck.getSensitiveParameters(resource);
        if (sensitiveParameters.isEmpty()) {
            return;
        }
        ContextualObject expressionEvaluationOptions = resource.object("expressionEvaluationOptions");
        ContextualProperty scope = expressionEvaluationOptions.property("scope");
        if (scope.isAbsent() || TextUtils.isValue(scope.valueOrNull(), "Inner").isFalse()) {
            Set<String> sensitiveParameterNames = sensitiveParameters.keySet();
            List<SecondaryLocation> sensitiveParameterUsages = SecureValuesExposureCheck.extractPropertyValuesFromTemplate(resource.object("template").list(RESOURCES_PROP_NAME)).filter(ArmTreeUtils.containsParameterReference(sensitiveParameterNames)).map(value -> new SecondaryLocation(value.textRange(), SECONDARY_MESSAGE)).toList();
            if (!sensitiveParameterUsages.isEmpty()) {
                ((ContextualProperty)scope.report(MESSAGE, sensitiveParameterUsages)).reportIfAbsent(MESSAGE, (List)sensitiveParameterUsages);
                expressionEvaluationOptions.reportIfAbsent(MESSAGE, sensitiveParameterUsages);
            }
        }
    }

    static Stream<Expression> extractPropertyValuesFromTemplate(ContextualArray resources) {
        return resources.objects().filter(ContextualTree::isPresent).flatMap(ContextualObject::allPropertiesFlattened).flatMap(prop -> {
            if (RESOURCES_PROP_NAME.equals(prop.name)) {
                return SecureValuesExposureCheck.extractPropertyValuesFromTemplate(ContextualArray.fromPresent(prop.ctx, (ArrayExpression)prop.valueOrNull(), RESOURCES_PROP_NAME, null));
            }
            return Stream.of(prop.valueOrNull());
        });
    }

    private static Map<String, ParameterDeclaration> getSensitiveParameters(ContextualResource resource) {
        File file = (File)ArmTreeUtils.getRootNode((ArmTree)resource.tree);
        return ArmTreeUtils.getParametersByNames(file).entrySet().stream().filter(it -> ((ParameterDeclaration)it.getValue()).type() == ParameterType.SECURE_OBJECT || ((ParameterDeclaration)it.getValue()).type() == ParameterType.SECURE_STRING).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

