/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.arm.checkdsl.ContextualObject;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.NumericLiteral;
import org.sonar.iac.common.api.checks.SecondaryLocation;

@Rule(key="S6413")
public class LogRetentionCheck
extends AbstractArmResourceCheck {
    private static final int DEFAULT_RETENTION_THRESHOLD = 14;
    private static final String RETENTION_DAY_NAME = "retentionDays";
    private static final String PROPERTY_OR_TYPE_OMITTED_MESSAGE = "Omitting \"%s\" results in a short log retention duration. Make sure it is safe here.";
    private static final String PROPERTY_DISABLED_MESSAGE = "Disabling \"%s\" results in a short log retention duration. Make sure it is safe here.";
    private static final String SHORT_LOG_RETENTION_DEFINED_MESSAGE = "Make sure that defining a short log retention duration is safe here.";
    private static final List<String> SIMPLE_LOG_RETENTION_RESOURCES = List.of("Microsoft.Sql/servers/auditingSettings", "Microsoft.Sql/servers/databases/securityAlertPolicies", "Microsoft.Sql/servers/auditingPolicies", "Microsoft.Synapse/workspaces/auditingSettings", "Microsoft.Synapse/workspaces/sqlPools/securityAlertPolicies", "Microsoft.DBforMariaDB/servers/securityAlertPolicies");
    @RuleProperty(key="log_retention_duration", defaultValue="14", description="Default minimum retention period in days.")
    public int retentionPeriodInDays = 14;

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Network/firewallPolicies", this.checkLogRetention("insights", "isEnabled", RETENTION_DAY_NAME));
        this.register("Microsoft.Network/networkWatchers/flowLogs", this.checkLogRetention("retentionPolicy", "enabled", "days"));
        this.register(SIMPLE_LOG_RETENTION_RESOURCES, this::checkLogRetentionAsSimpleProperty);
    }

    private Consumer<ContextualResource> checkLogRetention(String propertyName, String enablingTypeName, String retentionDayTypeName) {
        return resource -> {
            ContextualObject object = resource.object(propertyName);
            object.reportIfAbsent(String.format(PROPERTY_OR_TYPE_OMITTED_MESSAGE, propertyName), new SecondaryLocation[0]);
            ((ContextualProperty)object.property(enablingTypeName).reportIf(CheckUtils.isFalse(), String.format(PROPERTY_DISABLED_MESSAGE, enablingTypeName), new SecondaryLocation[0])).reportIfAbsent(String.format(PROPERTY_OR_TYPE_OMITTED_MESSAGE, enablingTypeName), new SecondaryLocation[0]);
            ((ContextualProperty)object.property(retentionDayTypeName).reportIf(this.isRetentionDaySensitive(), SHORT_LOG_RETENTION_DEFINED_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(String.format(PROPERTY_OR_TYPE_OMITTED_MESSAGE, retentionDayTypeName), new SecondaryLocation[0]);
        };
    }

    private void checkLogRetentionAsSimpleProperty(ContextualResource resource) {
        ((ContextualProperty)resource.property(RETENTION_DAY_NAME).reportIf(this.isRetentionDaySensitive(), SHORT_LOG_RETENTION_DEFINED_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(String.format(PROPERTY_OR_TYPE_OMITTED_MESSAGE, RETENTION_DAY_NAME), new SecondaryLocation[0]);
    }

    private Predicate<Expression> isRetentionDaySensitive() {
        return expr -> {
            if (!expr.is(ArmTree.Kind.NUMERIC_LITERAL)) {
                return false;
            }
            long retentionDays = Math.round(((NumericLiteral)expr).asDouble());
            return retentionDays < (long)this.retentionPeriodInDays && retentionDays != 0L;
        };
    }
}

