/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checkdsl.ContextualTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.checks.utils.PredicateUtils;
import org.sonar.iac.terraform.checks.utils.TerraformUtils;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class AzurePublicNetworkAccessCheckPart
extends AbstractNewResourceCheck {
    private static final Predicate<String> STARTS_WITH_AZURERM_PUBLIC_IP = PredicateUtils.exactMatchStringPredicate("azurerm_public_ip.*", 2);
    private static final Predicate<ExpressionTree> IS_PUBLIC_IP_ADDRESS = PredicateUtils.treePredicate(PredicateUtils.exactMatchStringPredicate("(10|172[.]16|192[.]168)[.].*|0[.]0[.]0[.]0/32").negate());

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("azurerm_batch_account", "azurerm_cognitive_account", "azurerm_container_registry", "azurerm_cosmosdb_account", "azurerm_databricks_workspace", "azurerm_eventgrid_domain", "azurerm_eventgrid_topic", "azurerm_healthcare_service", "azurerm_iothub", "azurerm_managed_disk", "azurerm_mariadb_server", "azurerm_mssql_server", "azurerm_mysql_server", "azurerm_postgresql_server", "azurerm_redis_cache", "azurerm_search_service", "azurerm_synapse_workspace"), AzurePublicNetworkAccessCheckPart.checkEnabledPublicIp("public_network_access_enabled"));
        this.register(List.of("azurerm_data_factory", "azurerm_purview_account"), AzurePublicNetworkAccessCheckPart.checkEnabledPublicIp("public_network_enabled"));
        this.register("azurerm_application_gateway", AzurePublicNetworkAccessCheckPart.checkPublicIpConfiguration("frontend_ip_configuration"));
        this.register("azurerm_network_interface", AzurePublicNetworkAccessCheckPart.checkPublicIpConfiguration("ip_configuration"));
        this.register(List.of("azurerm_dev_test_linux_virtual_machine", "azurerm_dev_test_windows_virtual_machine"), (ResourceSymbol resource) -> ((AttributeSymbol)resource.attribute("disallow_public_ip_address").reportIf(ExpressionPredicate.isFalse(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_dev_test_virtual_network", (ResourceSymbol resource) -> resource.block("subnet").attribute("use_public_ip_address").reportIf(ExpressionPredicate.notEqualTo("Deny"), "Make sure allowing public network access is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_kubernetes_cluster_node_pool", (ResourceSymbol resource) -> resource.attribute("enable_node_public_ip").reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_application_insights", (ResourceSymbol resource) -> {
            List<AttributeSymbol> attributes = Stream.of("internet_ingestion_enabled", "internet_query_enabled").map(resource::attribute).collect(Collectors.toList());
            if (attributes.stream().allMatch(ContextualTree::isAbsent)) {
                resource.report(String.format("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", "internet_ingestion_enabled\" and \"internet_query_enabled"), new SecondaryLocation[0]);
            } else {
                attributes.forEach(attribute -> ((AttributeSymbol)attribute.reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", new SecondaryLocation[0]));
            }
        });
        this.register("azurerm_sql_managed_instance", (ResourceSymbol resource) -> resource.attribute("public_data_endpoint_enabled").reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_kubernetes_cluster", (ResourceSymbol resource) -> {
            resource.block("default_node_pool").attribute("enable_node_public_ip").reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0]);
            resource.list("api_server_authorized_ip_ranges").reportItemIf(IS_PUBLIC_IP_ADDRESS, "Make sure that allowing public IP addresses is safe here.", new SecondaryLocation[0]);
        });
        this.register("azurerm_machine_learning_workspace", (ResourceSymbol resource) -> resource.attribute("public_network_access_enabled").reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0]));
    }

    private static Consumer<ResourceSymbol> checkEnabledPublicIp(String propertyName) {
        return resource -> ((AttributeSymbol)resource.attribute(propertyName).reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", new SecondaryLocation[0]);
    }

    private static Consumer<ResourceSymbol> checkPublicIpConfiguration(String propertyName) {
        return resource -> resource.blocks(propertyName).forEach(block -> block.attribute("public_ip_address_id").reportIf(e -> TerraformUtils.attributeAccessMatches(e, STARTS_WITH_AZURERM_PUBLIC_IP).isTrue(), "Make sure it is safe to use this public IP address.", new SecondaryLocation[0]));
    }
}

