/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.visitors;

import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.sonar.iac.common.api.tree.impl.TextPointer;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.YamlFileUtils;
import org.sonar.iac.helm.ShiftedMarkedYamlEngineException;

public class LocationShifter {
    private final Map<URI, LinesShifting> linesShiftingPerContext = new HashMap<URI, LinesShifting>();

    public void addShiftedLine(InputFileContext ctx, int transformedLine, int targetLine) {
        this.addShiftedLine(ctx, transformedLine, targetLine, targetLine);
    }

    public void addShiftedLine(InputFileContext ctx, int transformedLine, int targetStartLine, int targetEndLine) {
        LinesShifting shifting = this.getOrCreateLinesShifting(ctx);
        LineData linesData = shifting.getOrCreateLinesData(transformedLine);
        linesData.targetStartLine = targetStartLine;
        linesData.targetEndLine = targetEndLine;
    }

    public void readLinesSizes(String source, InputFileContext ctx) {
        String[] lines = YamlFileUtils.splitLines(source);
        for (int lineNumber = 1; lineNumber <= lines.length; ++lineNumber) {
            this.addLineSize(ctx, lineNumber, lines[lineNumber - 1].length());
        }
    }

    void addLineSize(InputFileContext ctx, int originalLine, int size) {
        this.getOrCreateLinesShifting((InputFileContext)ctx).originalLinesSizes.put(originalLine, size);
    }

    public TextRange computeShiftedLocation(InputFileContext ctx, TextRange textRange) {
        if (!this.linesShiftingPerContext.containsKey(ctx.inputFile.uri())) {
            return textRange;
        }
        LinesShifting shifting = this.getOrCreateLinesShifting(ctx);
        int lineStart = textRange.start().line();
        int lineEnd = textRange.end().line();
        Integer rangeStart = shifting.getClosestLineData(lineStart).map(p -> p.targetStartLine).orElse(shifting.getLastOriginalLine());
        TextPointer start = new TextPointer(rangeStart, 0);
        Optional<LineData> endLineData = shifting.getClosestLineData(lineEnd);
        Integer rangeEnd = endLineData.map(p -> p.targetEndLine).orElse(shifting.getLastOriginalLine());
        Integer rangeEndLineLength = this.getOrCreateLinesShifting((InputFileContext)ctx).originalLinesSizes.getOrDefault(rangeEnd, 0);
        TextPointer end = new TextPointer(rangeEnd, rangeEndLineLength);
        return new TextRange(start, end);
    }

    public MarkedYamlEngineException shiftMarkedYamlException(InputFileContext inputFileContext, MarkedYamlEngineException exception) {
        Optional<Mark> problemMark = exception.getProblemMark();
        if (problemMark.isPresent()) {
            Mark markInTransformedCode = problemMark.get();
            TextRange rangeInException = TextRanges.range(markInTransformedCode.getLine(), markInTransformedCode.getColumn(), markInTransformedCode.getLine(), markInTransformedCode.getColumn());
            TextRange shiftedRange = this.computeShiftedLocation(inputFileContext, rangeInException);
            Mark shiftedMark = new Mark(markInTransformedCode.getName(), markInTransformedCode.getIndex(), shiftedRange.start().line(), shiftedRange.start().lineOffset(), markInTransformedCode.getBuffer(), markInTransformedCode.getPointer());
            return new ShiftedMarkedYamlEngineException(exception, shiftedMark);
        }
        return exception;
    }

    private LinesShifting getOrCreateLinesShifting(InputFileContext ctx) {
        return this.linesShiftingPerContext.computeIfAbsent(ctx.inputFile.uri(), context -> new LinesShifting());
    }

    static class LinesShifting {
        private final Map<Integer, LineData> linesData = new TreeMap<Integer, LineData>();
        private final Map<Integer, Integer> originalLinesSizes = new HashMap<Integer, Integer>();

        LinesShifting() {
        }

        private LineData getOrCreateLinesData(Integer lineNumber) {
            return this.linesData.computeIfAbsent(lineNumber, line -> new LineData());
        }

        private Optional<LineData> getClosestLineData(Integer lineNumber) {
            return this.linesData.entrySet().stream().dropWhile(p -> (Integer)p.getKey() < lineNumber).findFirst().map(Map.Entry::getValue);
        }

        private Integer getLastOriginalLine() {
            return this.originalLinesSizes.keySet().stream().sorted(Comparator.reverseOrder()).mapToInt(i -> i).findFirst().orElse(0);
        }
    }

    static class LineData {
        private Integer targetStartLine;
        private Integer targetEndLine;

        LineData() {
        }
    }
}

