/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.visitors;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.TextPointer;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.SyntaxHighlightingVisitor;
import org.sonar.iac.common.yaml.YamlFileUtils;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.kubernetes.plugin.KubernetesParser;

public class KubernetesHighlightingVisitor
extends SyntaxHighlightingVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHighlightingVisitor.class);

    @Override
    protected void languageSpecificHighlighting() {
        this.register(FileTree.class, (ctx, tree) -> this.highlightContext((InputFileContext)ctx));
    }

    private void highlightContext(InputFileContext context) {
        try {
            this.highlightContent(context.inputFile.contents());
        }
        catch (IOException e) {
            LOG.error("Unable to read file: {}.", (Object)context.inputFile.uri(), (Object)e);
        }
    }

    void highlightContent(String content) {
        String[] lines = YamlFileUtils.splitLines(content);
        for (int i = 0; i < lines.length; ++i) {
            this.highlightLine(lines[i], i + 1);
        }
    }

    void highlightLine(String line, int lineNumber) {
        if (KubernetesParser.hasHelmContentInLine(line)) {
            return;
        }
        Matcher structureMatcher = YamlRegexPattern.STRUCTURAL_LINE_PATTERN.matcher(line);
        if (structureMatcher.matches()) {
            this.highlightGroupsInMatcher(structureMatcher, YamlRegexPattern.STRUCTURAL_LINE_GROUPNAMES, lineNumber);
            return;
        }
        Matcher combinedMatcher = YamlRegexPattern.KEY_VALUE_LINE_PATTERN.matcher(line);
        if (combinedMatcher.matches()) {
            this.highlightGroupsInMatcher(combinedMatcher, YamlRegexPattern.KEY_VALUE_LINE_GROUPNAMES, lineNumber);
            return;
        }
        Matcher scalarMatcher = YamlRegexPattern.VALUE_LINE_PATTERN.matcher(line);
        if (scalarMatcher.matches()) {
            this.highlightGroupsInMatcher(scalarMatcher, YamlRegexPattern.VALUE_LINE_GROUPNAMES, lineNumber);
        }
    }

    public void highlightGroupsInMatcher(Matcher matcher, Map<String, TypeOfText> groupNamesToType, int lineNumber) {
        for (Map.Entry<String, TypeOfText> groupNameToType : groupNamesToType.entrySet()) {
            this.highlightMatch(matcher, groupNameToType.getKey(), lineNumber, groupNameToType.getValue());
        }
    }

    public void highlightMatch(Matcher matcher, String groupName, int lineNumber, TypeOfText typeOfText) {
        String capturedGroup = matcher.group(groupName);
        if (capturedGroup == null || capturedGroup.isEmpty()) {
            return;
        }
        TextPointer startPointer = new TextPointer(lineNumber, matcher.start(groupName));
        TextPointer endPointer = new TextPointer(lineNumber, matcher.end(groupName));
        TextRange textRangeToHighlight = new TextRange(startPointer, endPointer);
        this.highlight(textRangeToHighlight, typeOfText);
    }

    @Override
    public void highlightComments(Tree tree) {
    }

    private static class YamlRegexPattern {
        private static final String DOUBLE_QUOTED_VALUE_GROUP_NAME = "doubleQuotedValue";
        private static final String SINGLE_QUOTED_VALUE_GROUP_NAME = "singleQuotedValue";
        private static final String QUOTELESS_VALUE_GROUP_NAME = "quotelessValue";
        private static final String COMMENT_GROUP_NAME = "comment";
        private static final String DOUBLE_QUOTED_KEY = YamlRegexPattern.doubleQuoted("doubleQuotedKey");
        private static final String DOUBLE_QUOTED_VALUE = YamlRegexPattern.doubleQuoted("doubleQuotedValue");
        private static final String SINGLE_QUOTED_KEY = YamlRegexPattern.singleQuoted("singleQuotedKey");
        private static final String SINGLE_QUOTED_VALUE = YamlRegexPattern.singleQuoted("singleQuotedValue");
        private static final String QUOTELESS_KEY = YamlRegexPattern.quoteless("quotelessKey");
        private static final String QUOTELESS_VALUE = YamlRegexPattern.quoteless("quotelessValue");
        private static final String MULTI_LINE_OPERATORS = "(?<multilineOperator>[|>])";
        private static final String KEY = DOUBLE_QUOTED_KEY + "|" + SINGLE_QUOTED_KEY + "|" + QUOTELESS_KEY;
        private static final String VALUE = DOUBLE_QUOTED_VALUE + "|" + SINGLE_QUOTED_VALUE + "|" + QUOTELESS_VALUE;
        private static final String COMMENT_S = "(?<comment>(?:(?<=\\h)|(?<![^.]))#.*+)?+";
        private static final String OPTIONAL_TAG = "(?<tag>!\\H++\\h?+)?+";
        private static final String DIRECTIVES = "(?<directive>%(?:TAG|YAML))\\h*+(?<handle>[!\\d][^#\\h]*+(?:\\h*+[^#\\h]++)?+)";
        private static final String STRUCTURAL_ELEMENTS = "(?<structure>\\.{3}|-{3})";
        private static final String KEY_VALUE_LINE = "\\h*+-?+\\h*+(?:" + KEY + "):(?:\\h++(?<tag>!\\H++\\h?+)?+(?:(?<multilineOperator>[|>])|" + VALUE + ")?+)?+\\h*+(?<comment>(?:(?<=\\h)|(?<![^.]))#.*+)?+";
        private static final String VALUE_LINE = "\\h*+-?+\\h*+(?<tag>!\\H++\\h?+)?+(?:(?<multilineOperator>[|>])|" + VALUE + ")?+\\h*+(?<comment>(?:(?<=\\h)|(?<![^.]))#.*+)?+";
        private static final Pattern STRUCTURAL_LINE_PATTERN = Pattern.compile("\\h*+(?:(?<directive>%(?:TAG|YAML))\\h*+(?<handle>[!\\d][^#\\h]*+(?:\\h*+[^#\\h]++)?+)|(?<structure>\\.{3}|-{3}))\\h*+(?<comment>(?:(?<=\\h)|(?<![^.]))#.*+)?+");
        private static final Pattern KEY_VALUE_LINE_PATTERN = Pattern.compile(KEY_VALUE_LINE);
        private static final Pattern VALUE_LINE_PATTERN = Pattern.compile(VALUE_LINE);
        private static final Map<String, TypeOfText> STRUCTURAL_LINE_GROUPNAMES = Map.of("directive", TypeOfText.KEYWORD_LIGHT, "structure", TypeOfText.KEYWORD_LIGHT, "handle", TypeOfText.STRING, "comment", TypeOfText.COMMENT);
        private static final Map<String, TypeOfText> VALUE_LINE_GROUPNAMES = Map.of("multilineOperator", TypeOfText.KEYWORD_LIGHT, "doubleQuotedValue", TypeOfText.STRING, "singleQuotedValue", TypeOfText.STRING, "quotelessValue", TypeOfText.STRING, "tag", TypeOfText.KEYWORD_LIGHT, "comment", TypeOfText.COMMENT);
        private static final Map<String, TypeOfText> KEY_VALUE_LINE_GROUPNAMES = Map.of("doubleQuotedKey", TypeOfText.KEYWORD, "singleQuotedKey", TypeOfText.KEYWORD, "quotelessKey", TypeOfText.KEYWORD, "multilineOperator", TypeOfText.KEYWORD_LIGHT, "tag", TypeOfText.KEYWORD_LIGHT, "doubleQuotedValue", TypeOfText.STRING, "singleQuotedValue", TypeOfText.STRING, "quotelessValue", TypeOfText.STRING, "comment", TypeOfText.COMMENT);

        private YamlRegexPattern() {
        }

        private static String doubleQuoted(String groupName) {
            return "(?<" + groupName + ">\"(?:\\\\.|[^\"])*+\")";
        }

        private static String singleQuoted(String groupName) {
            return "(?<" + groupName + ">'(?:''|[^'])*+')";
        }

        private static String quoteless(String groupName) {
            return "(?<" + groupName + ">(?:[^'\"%#:\\h](?:[^%:\\h]|\\h(?!#)|:(?=\\H))*+)?+)";
        }
    }
}

