/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.visitors;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.visitors.ChecksVisitor;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.kubernetes.visitors.LocationShifter;

public class AdjustableChecksVisitor
extends ChecksVisitor {
    private final LocationShifter locationShifter;

    public AdjustableChecksVisitor(Checks<IacCheck> checks, DurationStatistics statistics, LocationShifter locationShifter) {
        super(checks, statistics);
        this.locationShifter = locationShifter;
    }

    @Override
    protected InitContext context(RuleKey ruleKey) {
        return new AdjustableContextAdapter(ruleKey);
    }

    public class AdjustableContextAdapter
    extends ChecksVisitor.ContextAdapter {
        private InputFileContext currentCtx;

        public AdjustableContextAdapter(RuleKey ruleKey) {
            super(AdjustableChecksVisitor.this, ruleKey);
        }

        @Override
        public <T extends Tree> void register(Class<T> cls, BiConsumer<CheckContext, T> visitor) {
            AdjustableChecksVisitor.this.register(cls, AdjustableChecksVisitor.this.statistics.time(this.ruleKey.rule(), (ctx, tree) -> {
                this.currentCtx = ctx;
                visitor.accept(this, tree);
            }));
        }

        @Override
        protected void reportIssue(@Nullable TextRange textRange, String message, List<SecondaryLocation> secondaryLocations) {
            TextRange shiftedTextRange = textRange;
            if (textRange != null) {
                shiftedTextRange = AdjustableChecksVisitor.this.locationShifter.computeShiftedLocation(this.currentCtx, textRange);
            }
            List<SecondaryLocation> shiftedSecondaryLocations = secondaryLocations.stream().map(this::adaptSecondaryLocation).collect(Collectors.toList());
            this.currentCtx.reportIssue(this.ruleKey, shiftedTextRange, message, shiftedSecondaryLocations);
        }

        private SecondaryLocation adaptSecondaryLocation(SecondaryLocation secondaryLocation) {
            TextRange shiftedTextRange = AdjustableChecksVisitor.this.locationShifter.computeShiftedLocation(this.currentCtx, secondaryLocation.textRange);
            return new SecondaryLocation(shiftedTextRange, secondaryLocation.message);
        }
    }
}

