/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.common.yaml.YamlSensor;
import org.sonar.iac.common.yaml.visitors.YamlMetricsVisitor;
import org.sonar.iac.helm.utils.HelmFilesystemUtils;
import org.sonar.iac.kubernetes.checks.KubernetesCheckList;
import org.sonar.iac.kubernetes.plugin.HelmProcessor;
import org.sonar.iac.kubernetes.plugin.KubernetesLanguage;
import org.sonar.iac.kubernetes.plugin.KubernetesParser;
import org.sonar.iac.kubernetes.plugin.KubernetesParserStatistics;
import org.sonar.iac.kubernetes.visitors.AdjustableChecksVisitor;
import org.sonar.iac.kubernetes.visitors.KubernetesHighlightingVisitor;
import org.sonar.iac.kubernetes.visitors.LocationShifter;

public class KubernetesSensor
extends YamlSensor {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesSensor.class);
    private static final String HELM_ACTIVATION_KEY = "sonar.kubernetes.internal.helm.enable";
    private final HelmProcessor helmProcessor;
    private final LocationShifter locationShifter = new LocationShifter();
    private final KubernetesParserStatistics kubernetesParserStatistics = new KubernetesParserStatistics();

    public KubernetesSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, KubernetesLanguage language, HelmProcessor helmProcessor) {
        super(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, language, KubernetesCheckList.checks());
        this.helmProcessor = helmProcessor;
    }

    @Override
    protected void initContext(SensorContext sensorContext) {
        if (this.shouldEnableHelmAnalysis(sensorContext)) {
            LOG.debug("Initializing Helm processor");
            this.helmProcessor.initialize();
        } else {
            LOG.debug("Skipping initialization of Helm processor");
        }
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguages("yaml").name("IaC " + this.language.getName() + " Sensor");
    }

    @Override
    protected TreeParser<Tree> treeParser() {
        return new KubernetesParser(this.helmProcessor, this.locationShifter, this.kubernetesParserStatistics);
    }

    @Override
    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        ArrayList<TreeVisitor<InputFileContext>> visitors = new ArrayList<TreeVisitor<InputFileContext>>();
        if (this.isNotSonarLintContext(sensorContext)) {
            visitors.add(new KubernetesHighlightingVisitor());
            visitors.add(new YamlMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter));
        }
        visitors.add(new AdjustableChecksVisitor(this.checks, statistics, this.locationShifter));
        return visitors;
    }

    @Override
    protected String repositoryKey() {
        return "kubernetes";
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.kubernetes.activate";
    }

    @Override
    protected FilePredicate mainFilePredicate(SensorContext sensorContext) {
        FilePredicates predicates = sensorContext.fileSystem().predicates();
        return predicates.and(predicates.hasLanguage("yaml"), predicates.hasType(InputFile.Type.MAIN), this.customFilePredicate(sensorContext));
    }

    @Override
    protected FilePredicate customFilePredicate(SensorContext sensorContext) {
        FilePredicates predicates = sensorContext.fileSystem().predicates();
        FilePredicate helmTemplatePredicate = predicates.and(predicates.matchesPathPattern("**/templates/**"), (FilePredicate)new HelmProjectMemberPredicate(sensorContext));
        return predicates.or((FilePredicate)new KubernetesFilePredicate(), helmTemplatePredicate);
    }

    @Override
    protected void afterExecute() {
        this.kubernetesParserStatistics.logStatistics();
    }

    private boolean shouldEnableHelmAnalysis(SensorContext sensorContext) {
        boolean isNotSonarLintContext = this.isNotSonarLintContext(sensorContext);
        boolean isHelmAnalysisEnabled = sensorContext.config().getBoolean(HELM_ACTIVATION_KEY).orElse(true);
        boolean isHelmEvaluatorExecutableAvailable = HelmProcessor.isHelmEvaluatorExecutableAvailable();
        LOG.debug("Checking conditions for enabling Helm analysis: isNotSonarLintContext={}, isHelmActivationFlagTrue={}, isHelmEvaluatorExecutableAvailable={}", isNotSonarLintContext, isHelmAnalysisEnabled, isHelmEvaluatorExecutableAvailable);
        if (isNotSonarLintContext && isHelmAnalysisEnabled && !isHelmEvaluatorExecutableAvailable) {
            LOG.info("Helm analysis is not supported for the current platform");
        }
        return isNotSonarLintContext && isHelmAnalysisEnabled && isHelmEvaluatorExecutableAvailable;
    }

    static class HelmProjectMemberPredicate
    implements FilePredicate {
        private final SensorContext sensorContext;

        HelmProjectMemberPredicate(SensorContext sensorContext) {
            this.sensorContext = sensorContext;
        }

        @Override
        public boolean apply(InputFile inputFile) {
            return HelmFilesystemUtils.retrieveHelmProjectFolder(Path.of(inputFile.uri()), this.sensorContext.fileSystem().baseDir()) != null;
        }
    }

    static class KubernetesFilePredicate
    implements FilePredicate {
        private static final Pattern LINE_TERMINATOR = Pattern.compile("[\\n\\r\\u2028\\u2029]");
        private static final Set<String> IDENTIFIER = Set.of("apiVersion", "kind", "metadata");
        private static final Logger LOG = LoggerFactory.getLogger(KubernetesFilePredicate.class);
        private static final int DEFAULT_BUFFER_SIZE = 8192;

        KubernetesFilePredicate() {
        }

        @Override
        public boolean apply(InputFile inputFile) {
            return KubernetesFilePredicate.hasKubernetesObjectStructure(inputFile);
        }

        private static boolean hasKubernetesObjectStructure(InputFile inputFile) {
            int identifierCount = 0;
            boolean hasExpectedIdentifier = false;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputFile.inputStream());){
                String[] lines;
                byte[] bytes = bufferedInputStream.readNBytes(8192);
                String text = new String(bytes, inputFile.charset());
                for (String line : lines = LINE_TERMINATOR.split(text)) {
                    if (IDENTIFIER.stream().anyMatch(line::startsWith)) {
                        ++identifierCount;
                    } else if ("---".equals(line)) {
                        identifierCount = 0;
                    }
                    if (identifierCount != IDENTIFIER.size()) continue;
                    hasExpectedIdentifier = true;
                }
            }
            catch (IOException e) {
                LOG.error("Unable to read file: {}.", (Object)inputFile.uri());
                LOG.error(e.getMessage());
            }
            if (hasExpectedIdentifier) {
                return true;
            }
            LOG.debug("File without Kubernetes identifier: {}", (Object)inputFile.uri());
            return false;
        }
    }
}

