/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin;

import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.YamlFileUtils;
import org.sonar.iac.common.yaml.YamlParser;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.helm.LineNumberCommentRemover;
import org.sonar.iac.helm.ShiftedMarkedYamlEngineException;
import org.sonar.iac.helm.utils.HelmFilesystemUtils;
import org.sonar.iac.kubernetes.plugin.HelmProcessor;
import org.sonar.iac.kubernetes.plugin.KubernetesParserStatistics;
import org.sonar.iac.kubernetes.visitors.LocationShifter;

public class KubernetesParser
extends YamlParser {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesParser.class);
    private static final String DIRECTIVE_IN_COMMENT = "#.*\\{\\{";
    private static final String DIRECTIVE_IN_SINGLE_QUOTE = "'[^']*\\{\\{[^']*'";
    private static final String DIRECTIVE_IN_DOUBLE_QUOTE = "\"[^\"]*\\{\\{[^\"]*\"";
    private static final String CODEFRESH_VARIABLES = "\\$\\{\\{[\\w\\s]+}}";
    private static final Pattern HELM_DIRECTIVE_IN_COMMENT_OR_STRING = Pattern.compile("(" + String.join((CharSequence)"|", "#.*\\{\\{", "'[^']*\\{\\{[^']*'", "\"[^\"]*\\{\\{[^\"]*\"", "\\$\\{\\{[\\w\\s]+}}") + ")");
    private final HelmProcessor helmProcessor;
    private final LocationShifter locationShifter;
    private final KubernetesParserStatistics kubernetesParserStatistics;

    public KubernetesParser(HelmProcessor helmProcessor, LocationShifter locationShifter, KubernetesParserStatistics kubernetesParserStatistics) {
        this.helmProcessor = helmProcessor;
        this.locationShifter = locationShifter;
        this.kubernetesParserStatistics = kubernetesParserStatistics;
    }

    @Override
    public FileTree parse(String source, @Nullable InputFileContext inputFileContext) {
        if (!KubernetesParser.hasHelmContent(source)) {
            return this.kubernetesParserStatistics.recordPureKubernetesFile(() -> super.parse(source, inputFileContext));
        }
        return this.kubernetesParserStatistics.recordHelmFile(() -> this.parseHelmFile(source, inputFileContext));
    }

    private FileTree parseHelmFile(String source, @Nullable InputFileContext inputFileContext) {
        FileTree result;
        if (inputFileContext == null) {
            LOG.debug("No InputFileContext provided, skipping processing of Helm file");
            return super.parse("{}", null, FileTree.Template.HELM);
        }
        LOG.debug("Helm content detected in file '{}'", (Object)inputFileContext.inputFile);
        if (!this.helmProcessor.isHelmEvaluatorInitialized()) {
            LOG.debug("Helm evaluator is not initialized, skipping processing of Helm file {}", (Object)inputFileContext.inputFile);
            return super.parse("{}", null, FileTree.Template.HELM);
        }
        try {
            result = this.evaluateAndParseHelmFile(source, inputFileContext);
        }
        catch (ParseException pe) {
            String details = pe.getDetails();
            if (details != null && details.contains("\" associated with template \"aggregatingTemplate\"")) {
                LOG.debug("Helm file {} requires a named template that is missing; this feature is not yet supported, skipping processing of Helm file", (Object)inputFileContext.inputFile);
                result = super.parse("{}", null, FileTree.Template.HELM);
            }
            throw pe;
        }
        catch (MarkedYamlEngineException e) {
            MarkedYamlEngineException shifted = this.locationShifter.shiftMarkedYamlException(inputFileContext, e);
            if (shifted instanceof ShiftedMarkedYamlEngineException) {
                LOG.debug("Shifting YAML exception {}", (Object)((ShiftedMarkedYamlEngineException)shifted).describeShifting());
            }
            throw shifted;
        }
        return result;
    }

    private FileTree evaluateAndParseHelmFile(String source, InputFileContext inputFileContext) {
        this.locationShifter.readLinesSizes(source, inputFileContext);
        String fileRelativePath = KubernetesParser.getFileRelativePath(inputFileContext);
        String evaluatedSource = this.helmProcessor.processHelmTemplate(fileRelativePath, source, inputFileContext);
        String evaluatedAndCleanedSource = LineNumberCommentRemover.cleanSource(evaluatedSource, inputFileContext, this.locationShifter);
        if (evaluatedAndCleanedSource.isBlank()) {
            LOG.debug("Blank evaluated file, skipping processing of Helm file {}", (Object)inputFileContext.inputFile);
            return super.parse("{}", null, FileTree.Template.HELM);
        }
        return super.parse(evaluatedAndCleanedSource, inputFileContext, FileTree.Template.HELM);
    }

    private static String getFileRelativePath(InputFileContext inputFileContext) {
        String fileRelativePath;
        Path filePath = Path.of(inputFileContext.inputFile.uri());
        Path chartRootDirectory = HelmFilesystemUtils.retrieveHelmProjectFolder(filePath, inputFileContext.sensorContext.fileSystem().baseDir());
        if (chartRootDirectory == null) {
            fileRelativePath = inputFileContext.inputFile.filename();
        } else {
            fileRelativePath = chartRootDirectory.relativize(filePath).normalize().toString();
            fileRelativePath = HelmFilesystemUtils.normalizeToUnixPathSeparator(fileRelativePath);
        }
        return fileRelativePath;
    }

    public static boolean hasHelmContent(String text) {
        String[] lines;
        for (String line : lines = YamlFileUtils.splitLines(text)) {
            if (!KubernetesParser.hasHelmContentInLine(line)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHelmContentInLine(String line) {
        return line.contains("{{") && !HELM_DIRECTIVE_IN_COMMENT_OR_STRING.matcher(line).find();
    }
}

