/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.helm.HelmEvaluator;
import org.sonar.iac.helm.LineNumberCommentInserter;
import org.sonar.iac.helm.utils.HelmFilesystemUtils;
import org.sonar.iac.helm.utils.OperatingSystemUtils;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.iac.helm.TemplateEvaluationResult;

@ScannerSide
@SonarLintSide
@ExtensionPoint
public class HelmProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(HelmProcessor.class);
    private HelmEvaluator helmEvaluator;

    public HelmProcessor(HelmEvaluator helmEvaluator) {
        this.helmEvaluator = helmEvaluator;
    }

    public static boolean isHelmEvaluatorExecutableAvailable() {
        return OperatingSystemUtils.getCurrentPlatformIfSupported().isPresent();
    }

    public void initialize() {
        try {
            this.helmEvaluator.initialize();
        }
        catch (IOException e) {
            LOG.debug("Failed to initialize Helm evaluator, analysis of Helm files will be disabled", e);
            this.helmEvaluator = null;
        }
    }

    public boolean isHelmEvaluatorInitialized() {
        return this.helmEvaluator != null;
    }

    String processHelmTemplate(String path, String source, InputFileContext inputFileContext) {
        if (!this.isHelmEvaluatorInitialized()) {
            throw new IllegalStateException("Attempt to process Helm template with uninitialized Helm evaluator");
        }
        if (source.isBlank()) {
            LOG.debug("The file {} is blank, skipping evaluation", (Object)inputFileContext.inputFile);
            return source;
        }
        String sourceWithComments = LineNumberCommentInserter.addLineComments(source);
        Map<String, InputFile> additionalFiles = HelmFilesystemUtils.additionalFilesOfHelmProjectDirectory(inputFileContext);
        Map<String, String> fileContents = HelmProcessor.validateAndReadFiles(inputFileContext.inputFile, additionalFiles);
        return this.evaluateHelmTemplate(path, inputFileContext.inputFile, sourceWithComments, fileContents);
    }

    private static Map<String, String> validateAndReadFiles(InputFile inputFile, Map<String, InputFile> files) {
        if (!files.containsKey("values.yaml") && !files.containsKey("values.yml")) {
            throw HelmProcessor.parseExceptionFor(inputFile, "Failed to find values file", null);
        }
        HashMap<String, String> fileContents = new HashMap<String, String>(files.size());
        for (Map.Entry<String, InputFile> filenameToInputFile : files.entrySet()) {
            String fileContent;
            InputFile additionalInputFile = filenameToInputFile.getValue();
            try {
                fileContent = additionalInputFile.contents();
            }
            catch (IOException e) {
                throw HelmProcessor.parseExceptionFor(inputFile, "Failed to read file at " + additionalInputFile, e.getMessage());
            }
            fileContents.put(filenameToInputFile.getKey(), fileContent);
        }
        return fileContents;
    }

    private String evaluateHelmTemplate(String path, InputFile inputFile, String content, Map<String, String> templateDependencies) {
        try {
            TemplateEvaluationResult evaluationResult = this.helmEvaluator.evaluateTemplate(path, content, templateDependencies);
            return evaluationResult.getTemplate();
        }
        catch (IOException | IllegalStateException e) {
            throw HelmProcessor.parseExceptionFor(inputFile, "Template evaluation failed", e.getMessage());
        }
    }

    private static ParseException parseExceptionFor(InputFile inputFile, String cause, @Nullable String details) {
        return new ParseException("Failed to evaluate Helm file " + inputFile + ": " + cause, null, details);
    }
}

