/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.yaml.tree.ScalarTree;

@Rule(key="S5332")
public class ClearTextProtocolsCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure that using clear-text protocols is safe here.";
    private static final List<String> INSECURE_PROTOCOLS = List.of("http://", "ftp://");
    private static final Pattern LOOPBACK_PATTERN = Pattern.compile("localhost|127(?:\\.\\d+){0,2}\\.\\d+$|^(?:0*:)*+:?0*1", 2);

    @Override
    public void initialize(InitContext init) {
        init.register(ScalarTree.class, ClearTextProtocolsCheck::checkUrlsInScalar);
    }

    private static void checkUrlsInScalar(CheckContext ctx, ScalarTree scalarTree) {
        String scalar = scalarTree.value();
        if (INSECURE_PROTOCOLS.stream().noneMatch(scalar.toLowerCase(Locale.ROOT)::startsWith)) {
            return;
        }
        try {
            URL url = new URL(scalar);
            String domain = url.getHost();
            if (!LOOPBACK_PATTERN.matcher(domain).find()) {
                ctx.reportIssue(scalarTree, MESSAGE);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

