/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.AttributeObject;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;

@Rule(key="S6865")
public class AutomountServiceAccountTokenCheck
extends AbstractKubernetesObjectCheck {
    private static final String MESSAGE = "Set automountServiceAccountToken to false for this specification of kind %s.";
    private static final String KEY = "automountServiceAccountToken";
    private static final String KIND_POD = "Pod";
    private static final List<String> KIND_WITH_TEMPLATE = List.of("DaemonSet", "Deployment", "Job", "ReplicaSet", "ReplicationController", "StatefulSet", "CronJob");

    @Override
    boolean shouldVisitWholeDocument() {
        return true;
    }

    @Override
    void registerObjectCheck() {
        this.register(KIND_POD, (BlockObject document) -> AutomountServiceAccountTokenCheck.checkAndReport(document, String.format(MESSAGE, KIND_POD)));
        for (String kind : KIND_WITH_TEMPLATE) {
            this.register(kind, (BlockObject document) -> AutomountServiceAccountTokenCheck.checkAndReport(document.block("spec").block("template"), String.format(MESSAGE, kind)));
        }
    }

    private static void checkAndReport(BlockObject blockObject, String message) {
        BlockObject specAsBlockObject = blockObject.block("spec");
        AttributeObject specAsAttributeObject = blockObject.attribute("spec");
        if (specAsAttributeObject.tree != null && AutomountServiceAccountTokenCheck.isContainersPresentInSpecBlock(specAsBlockObject)) {
            AttributeObject tokenAttribute = specAsBlockObject.attribute(KEY);
            tokenAttribute.reportIfAbsent(((TupleTree)specAsAttributeObject.tree).key(), message);
            tokenAttribute.reportIfValue(TreePredicates.isSet().negate(), message);
            tokenAttribute.reportIfValue(TreePredicates.isTrue(), message);
        }
    }

    private static boolean isContainersPresentInSpecBlock(BlockObject blockObject) {
        return blockObject.attribute((String)"containers").tree != null;
    }
}

