/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.TupleTree;

public abstract class AbstractKubernetesObjectCheck
implements IacCheck {
    private final Map<String, List<Consumer<BlockObject>>> objectConsumersByKind = new HashMap<String, List<Consumer<BlockObject>>>();

    @Override
    public void initialize(InitContext init) {
        init.register(FileTree.class, (CheckContext ctx, T fileTree) -> fileTree.documents().stream().filter(MappingTree.class::isInstance).forEach(documentTree -> this.visitDocument((MappingTree)documentTree, (CheckContext)ctx)));
        this.registerObjectCheck();
    }

    void visitDocument(MappingTree documentTree, CheckContext ctx) {
        PropertyUtils.get((Tree)documentTree, "kind").flatMap(kind -> TextUtils.getValue(kind.value())).filter(this.objectConsumersByKind::containsKey).ifPresent(kind -> {
            if (this.shouldVisitWholeDocument()) {
                this.visitMappingTreeForKind(documentTree, ctx, (String)kind);
            } else {
                this.visitSpecTreeForKind(documentTree, ctx, (String)kind);
            }
        });
    }

    boolean shouldVisitWholeDocument() {
        return false;
    }

    private void visitSpecTreeForKind(MappingTree documentTree, CheckContext ctx, String kind) {
        PropertyUtils.get((Tree)documentTree, "spec").filter(TupleTree.class::isInstance).map(TupleTree.class::cast).filter(spec -> spec.value() instanceof MappingTree).map(spec -> (MappingTree)spec.value()).ifPresent(specValue -> this.visitMappingTreeForKind((MappingTree)specValue, ctx, kind));
    }

    private void visitMappingTreeForKind(MappingTree mappingTree, CheckContext ctx, String kind) {
        BlockObject blockObject = BlockObject.fromPresent(ctx, mappingTree, kind);
        this.objectConsumersByKind.get(kind).forEach(consumer -> consumer.accept(blockObject));
    }

    abstract void registerObjectCheck();

    protected void register(String kind, Consumer<BlockObject> consumer) {
        this.objectConsumersByKind.computeIfAbsent(kind, s -> new ArrayList()).add(consumer);
    }

    protected void register(Iterable<String> kinds, Consumer<BlockObject> consumer) {
        kinds.forEach(kind -> this.register((String)kind, consumer));
    }
}

