/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.helm.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.iac.common.extension.visitors.InputFileContext;

public final class HelmFilesystemUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HelmFilesystemUtils.class);
    private static final Set<String> INCLUDED_EXTENSIONS = Set.of("yaml", "yml", "tpl", "txt", "toml", "properties");

    private HelmFilesystemUtils() {
    }

    public static Map<String, InputFile> additionalFilesOfHelmProjectDirectory(InputFileContext inputFileContext) {
        HashMap<String, InputFile> result = new HashMap<String, InputFile>();
        Path helmDirectoryPath = HelmFilesystemUtils.retrieveHelmProjectFolder(Path.of(inputFileContext.inputFile.uri()), inputFileContext.sensorContext.fileSystem().baseDir());
        if (helmDirectoryPath == null) {
            LOG.debug("Failed to resolve Helm project directory for {}", (Object)inputFileContext.inputFile.uri());
            return result;
        }
        FilePredicate filePredicate = HelmFilesystemUtils.additionalHelmDependenciesPredicate(inputFileContext, helmDirectoryPath);
        Iterable<InputFile> inputFiles = inputFileContext.sensorContext.fileSystem().inputFiles(filePredicate);
        for (InputFile additionalFile : inputFiles) {
            String fileName = HelmFilesystemUtils.resolveToInputFile(helmDirectoryPath, additionalFile);
            result.put(HelmFilesystemUtils.normalizeToUnixPathSeparator(fileName), additionalFile);
        }
        return result;
    }

    static FilePredicate additionalHelmDependenciesPredicate(InputFileContext inputFileContext, Path helmProjectDirectoryPath) {
        FilePredicates predicates = inputFileContext.sensorContext.fileSystem().predicates();
        String pathPattern = null;
        Path basePath = HelmFilesystemUtils.normalizePathForWindows(inputFileContext.sensorContext.fileSystem().baseDir().toPath());
        helmProjectDirectoryPath = HelmFilesystemUtils.normalizePathForWindows(helmProjectDirectoryPath);
        if (basePath != null && helmProjectDirectoryPath != null) {
            Path relativizedPath = basePath.relativize(helmProjectDirectoryPath);
            pathPattern = relativizedPath + File.separator + "**";
        }
        if (pathPattern == null) {
            return predicates.none();
        }
        return predicates.and(predicates.matchesPathPattern(pathPattern), HelmFilesystemUtils.extensionPredicate(predicates), predicates.not(predicates.hasURI(inputFileContext.inputFile.uri())));
    }

    private static FilePredicate extensionPredicate(FilePredicates predicates) {
        Set<FilePredicate> extensionPredicates = INCLUDED_EXTENSIONS.stream().map(predicates::hasExtension).collect(Collectors.toSet());
        return predicates.or(extensionPredicates);
    }

    @CheckForNull
    public static Path retrieveHelmProjectFolder(Path inputFilePath, File baseDir) {
        Path helmProjectDirectoryPath;
        Path baseDirPath = HelmFilesystemUtils.normalizePathForWindows(baseDir.toPath());
        if (baseDirPath == null) {
            return null;
        }
        for (helmProjectDirectoryPath = inputFilePath; helmProjectDirectoryPath != null && helmProjectDirectoryPath.startsWith(baseDirPath) && !Files.exists(helmProjectDirectoryPath.resolve("Chart.yaml"), new LinkOption[0]); helmProjectDirectoryPath = helmProjectDirectoryPath.getParent()) {
        }
        if (helmProjectDirectoryPath != null && !helmProjectDirectoryPath.startsWith(baseDirPath)) {
            return null;
        }
        return helmProjectDirectoryPath;
    }

    private static String resolveToInputFile(Path helmDirectoryPath, InputFile additionalFile) {
        return helmDirectoryPath.relativize(Path.of(additionalFile.uri())).toString();
    }

    public static String normalizeToUnixPathSeparator(String filename) {
        return filename.replace(File.separatorChar, '/');
    }

    @CheckForNull
    public static Path normalizePathForWindows(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            LOG.debug("Failed to normalize path for windows: {}", (Object)path);
            return null;
        }
    }
}

