/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.helm;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.TempFolder;
import org.sonar.iac.helm.utils.ExecutableHelper;
import org.sonar.iac.helm.utils.OperatingSystemUtils;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.iac.helm.TemplateEvaluationResult;

@ScannerSide
@SonarLintSide(lifespan="INSTANCE")
public class HelmEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(HelmEvaluator.class);
    public static final String HELM_FOR_IAC_EXECUTABLE = "sonar-helm-for-iac";
    private static final int PROCESS_TIMEOUT_SECONDS = 5;
    private final File workingDir;
    private final ExecutorService processMonitor = Executors.newFixedThreadPool(2);
    private ProcessBuilder processBuilder;

    public HelmEvaluator(TempFolder tempFolder) {
        this.workingDir = tempFolder.newDir();
    }

    public void initialize() throws IOException {
        this.processBuilder = this.prepareProcessBuilder();
    }

    public TemplateEvaluationResult evaluateTemplate(String path, String content, Map<String, String> templateDependencies) throws IOException {
        LOG.debug("Executing: {}", (Object)this.processBuilder.command());
        Process process = this.startProcess();
        this.processMonitor.submit(() -> ExecutableHelper.readProcessErrorOutput(process));
        this.writeTemplateAndDependencies(process, path, content, templateDependencies);
        this.processMonitor.submit(() -> HelmEvaluator.monitorProcess(process));
        byte[] rawEvaluationResult = ExecutableHelper.readProcessOutput(process);
        if (rawEvaluationResult == null || rawEvaluationResult.length == 0) {
            if (!process.isAlive() && process.exitValue() != 0) {
                throw new IllegalStateException("sonar-helm-for-iac exited with non-zero exit code: " + process.exitValue() + ", possible serialization failure");
            }
            throw new IllegalStateException("Empty evaluation result returned from sonar-helm-for-iac");
        }
        try {
            TemplateEvaluationResult evaluationResult = TemplateEvaluationResult.parseFrom(rawEvaluationResult);
            if (!evaluationResult.getError().isEmpty()) {
                throw new IllegalStateException("Evaluation error in Go library: " + evaluationResult.getError());
            }
            return evaluationResult;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Deserialization error", e);
        }
    }

    ProcessBuilder prepareProcessBuilder() throws IOException {
        String suffix = OperatingSystemUtils.getCurrentPlatformIfSupported().orElseThrow(() -> new IllegalStateException("HelmEvaluator is being initialized on an unsupported platform"));
        String executable = ExecutableHelper.extractFromClasspath(this.workingDir, "sonar-helm-for-iac-" + suffix);
        return new ProcessBuilder(executable);
    }

    Process startProcess() throws IOException {
        return this.processBuilder.start();
    }

    void writeTemplateAndDependencies(Process process, String name, String content, Map<String, String> templateDependencies) throws IOException {
        try (OutputStream out = process.getOutputStream();){
            HelmEvaluator.writeFileToProcess(out, name, content);
            for (Map.Entry<String, String> filenameToFileContent : templateDependencies.entrySet()) {
                HelmEvaluator.writeFileToProcess(out, filenameToFileContent.getKey(), filenameToFileContent.getValue());
            }
            HelmEvaluator.writeStringAsBytes(out, String.format("END%n", new Object[0]));
        }
    }

    private static void writeFileToProcess(OutputStream out, String fileName, String content) throws IOException {
        HelmEvaluator.writeStringAsBytes(out, String.format("%s%n", fileName));
        HelmEvaluator.writeStringAsBytes(out, String.format("%d%n", ((String)content).lines().count()));
        if (!((String)content).endsWith("\n")) {
            content = (String)content + "\n";
        }
        HelmEvaluator.writeStringAsBytes(out, (String)content);
    }

    private static void writeStringAsBytes(OutputStream out, String content) throws IOException {
        out.write(content.getBytes(StandardCharsets.UTF_8));
    }

    private static void monitorProcess(Process process) {
        try {
            if (!process.waitFor(5L, TimeUnit.SECONDS)) {
                LOG.debug("sonar-helm-for-iac is taking longer than 5 seconds to finish");
                process.destroy();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for process to finish", e);
            Thread.currentThread().interrupt();
        }
    }
}

