/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils;

import java.util.List;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.checks.utils.FlagNoSpaceArgumentPredicate;
import org.sonar.iac.docker.checks.utils.StringPredicate;

public final class StandardCommandDetectors {
    private StandardCommandDetectors() {
    }

    public static CommandDetector commandFlagNoSpace(String command, String flag) {
        return StandardCommandDetectors.commandFlagNoSpace(List.of(command), flag);
    }

    public static CommandDetector commandFlagNoSpace(List<String> commands, String flag) {
        return CommandDetector.builder().with(commands).withAnyIncludingUnresolvedRepeating(StringPredicate.startsWithIgnoreQuotes(flag).negate()).withArgumentResolutionIncludeUnresolved(new FlagNoSpaceArgumentPredicate(flag)).build();
    }

    public static CommandDetector commandFlagEquals(String command, String flag) {
        return StandardCommandDetectors.commandFlagEquals(List.of(command), flag);
    }

    public static CommandDetector commandFlagEquals(List<String> commands, String flag) {
        String flagAndEquals = flag + "=";
        return CommandDetector.builder().with(commands).withAnyIncludingUnresolvedRepeating(StringPredicate.startsWithIgnoreQuotes(flagAndEquals).negate()).withIncludeUnresolved(StringPredicate.startsWithIgnoreQuotes(flagAndEquals)).build();
    }

    public static CommandDetector commandFlagSpace(String command, String flag) {
        return CommandDetector.builder().with(command).withOptionalRepeatingExcept(StringPredicate.equalsIgnoreQuotes(flag)).with(StringPredicate.equalsIgnoreQuotes(flag)).withIncludeUnresolved(a -> true).build();
    }
}

