/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.checks.utils.ArgumentResolutionSplitter;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.CmdInstruction;
import org.sonar.iac.docker.tree.api.CommandInstruction;
import org.sonar.iac.docker.tree.api.EntrypointInstruction;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6597")
public class WorkdirInsteadCdCheck
implements IacCheck {
    private static final String MESSAGE = "WORKDIR instruction should be used instead of cd command.";
    private static final CommandDetector COMMAND_DETECTOR = CommandDetector.builder().with("cd").withAnyFlag().with(e -> true).build();

    @Override
    public void initialize(InitContext init) {
        init.register(RunInstruction.class, CheckUtils.ignoringHeredoc(WorkdirInsteadCdCheck::checkCommandInstruction));
        init.register(CmdInstruction.class, WorkdirInsteadCdCheck::checkCommandInstruction);
        init.register(EntrypointInstruction.class, WorkdirInsteadCdCheck::checkCommandInstruction);
    }

    private static void checkCommandInstruction(CheckContext ctx, CommandInstruction commandInstruction) {
        List<ArgumentResolution> argumentResolutions = CheckUtils.resolveInstructionArguments(commandInstruction);
        List<List<ArgumentResolution>> separatedArguments = ArgumentResolutionSplitter.splitCommands(argumentResolutions).elements();
        List<List<ArgumentResolution>> argumentsToCheck = WorkdirInsteadCdCheck.takeFirstAndLastArgument(separatedArguments);
        for (List<ArgumentResolution> arguments : argumentsToCheck) {
            COMMAND_DETECTOR.searchWithoutSplit(arguments).forEach(command -> ctx.reportIssue((HasTextRange)command, MESSAGE));
        }
    }

    private static List<List<ArgumentResolution>> takeFirstAndLastArgument(List<List<ArgumentResolution>> elements) {
        List<List<ArgumentResolution>> toCheck;
        if (elements.size() == 1) {
            toCheck = elements;
        } else {
            toCheck = new ArrayList<List<ArgumentResolution>>();
            toCheck.add(elements.get(0));
            toCheck.add(elements.get(elements.size() - 1));
        }
        return toCheck;
    }
}

