/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.tree.api.Body;
import org.sonar.iac.docker.tree.api.DockerImage;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.Instruction;

@Rule(key="S6589")
public class UniqueInstructionPresenceCheck
implements IacCheck {
    private static final String MESSAGE = "Remove this %s instruction which will be ignored.";
    private static final Map<DockerTree.Kind, String> UNIQUE_INSTRUCTION_KINDS_WITH_LABEL = Map.of(DockerTree.Kind.CMD, "CMD", DockerTree.Kind.ENTRYPOINT, "ENTRYPOINT");

    @Override
    public void initialize(InitContext init) {
        init.register(Body.class, UniqueInstructionPresenceCheck::checkUniqueInstruction);
    }

    private static void checkUniqueInstruction(CheckContext ctx, Body body) {
        for (DockerImage image : body.dockerImages()) {
            Map<DockerTree.Kind, List<Instruction>> foundInstructionsPerKind = UniqueInstructionPresenceCheck.searchInstructionOfKinds(image.instructions(), UNIQUE_INSTRUCTION_KINDS_WITH_LABEL.keySet());
            UniqueInstructionPresenceCheck.reportIssueOnDuplicateInstruction(ctx, foundInstructionsPerKind);
        }
    }

    private static Map<DockerTree.Kind, List<Instruction>> searchInstructionOfKinds(List<Instruction> instructions, Set<DockerTree.Kind> kinds) {
        EnumMap<DockerTree.Kind, List<Instruction>> foundInstructionsOfKind = new EnumMap<DockerTree.Kind, List<Instruction>>(DockerTree.Kind.class);
        instructions.stream().filter(instruction -> kinds.contains(instruction.getKind())).forEach(instruction -> foundInstructionsOfKind.computeIfAbsent(instruction.getKind(), key -> new ArrayList()).add(instruction));
        return foundInstructionsOfKind;
    }

    private static void reportIssueOnDuplicateInstruction(CheckContext ctx, Map<DockerTree.Kind, List<Instruction>> instructionsPerKind) {
        for (Map.Entry<DockerTree.Kind, List<Instruction>> instructionsWithKind : instructionsPerKind.entrySet()) {
            String kindLabel = UNIQUE_INSTRUCTION_KINDS_WITH_LABEL.get(instructionsWithKind.getKey());
            List<Instruction> instructions = instructionsWithKind.getValue();
            for (Instruction instruction : instructions.subList(0, instructions.size() - 1)) {
                ctx.reportIssue(instruction, String.format(MESSAGE, kindLabel));
            }
        }
    }
}

