/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.symbols.Scope;
import org.sonar.iac.docker.symbols.Symbol;
import org.sonar.iac.docker.tree.api.DockerImage;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.Literal;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6581")
public class MisusedUnsetCheck
implements IacCheck {
    private static final String MESSAGE = "Use the ARG instruction or set and unset the environment variable in a single layer.";

    @Override
    public void initialize(InitContext init) {
        init.register(DockerImage.class, (ctx, image) -> image.instructions().stream().filter(RunInstruction.class::isInstance).map(RunInstruction.class::cast).forEach(runInstruction -> MisusedUnsetCheck.checkCommandsIn(runInstruction, ctx, image.scope())));
    }

    private static void checkCommandsIn(RunInstruction runInstruction, CheckContext ctx, Scope scope) {
        List<ArgumentResolution> argumentResolutions = CheckUtils.resolveInstructionArguments(runInstruction);
        CommandDetector unsetDetector = CommandDetector.builder().with("unset").withAnyFlagExcept("-f").withOptionalRepeating(s -> true).build();
        unsetDetector.search(argumentResolutions).forEach(c -> MisusedUnsetCheck.checkMatchedCommand(c, ctx, scope));
    }

    private static void checkMatchedCommand(CommandDetector.Command command, CheckContext ctx, Scope scope) {
        command.getResolvedArguments().stream().skip(1L).dropWhile(resolution -> resolution.value().startsWith("-")).forEach(resolution -> MisusedUnsetCheck.reportArgumentIfNonCompliant(resolution, ctx, scope));
    }

    private static void reportArgumentIfNonCompliant(ArgumentResolution resolution, CheckContext ctx, Scope scope) {
        Literal argument = (Literal)resolution.argument().expressions().get(0);
        Symbol symbol = scope.getSymbol(argument.value());
        if (symbol != null && MisusedUnsetCheck.isDefinedAsEnv(symbol)) {
            ctx.reportIssue(argument.textRange(), MESSAGE);
        }
    }

    private static boolean isDefinedAsEnv(Symbol symbol) {
        return symbol.usages().get(0).tree().parent().is(DockerTree.Kind.ENV);
    }
}

