/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml.object;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.yaml.object.YamlObject;
import org.sonar.iac.common.yaml.tree.SequenceTree;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

public class ListObject
extends YamlObject<ListObject, SequenceTree> {
    protected final List<YamlTree> items;
    private final YamlTree parent;

    ListObject(CheckContext ctx, @Nullable SequenceTree tree, String key, YamlObject.Status status, @Nullable YamlTree parent, List<YamlTree> items) {
        super(ctx, tree, key, status);
        this.parent = parent;
        this.items = items;
    }

    public static ListObject fromPresent(CheckContext ctx, YamlTree tree, String key, YamlTree parent) {
        if (tree instanceof TupleTree) {
            return ListObject.fromPresent(ctx, ((TupleTree)tree).value(), key, tree);
        }
        if (tree instanceof SequenceTree) {
            return new ListObject(ctx, (SequenceTree)tree, key, YamlObject.Status.PRESENT, parent, ((SequenceTree)tree).elements());
        }
        return new ListObject(ctx, null, key, YamlObject.Status.UNKNOWN, null, Collections.emptyList());
    }

    public static ListObject fromAbsent(CheckContext ctx, String key) {
        return new ListObject(ctx, null, key, YamlObject.Status.ABSENT, null, Collections.emptyList());
    }

    public Stream<YamlTree> getItemIf(Predicate<YamlTree> predicate) {
        return this.items.stream().filter(predicate);
    }

    public ListObject reportIfAnyItem(Predicate<YamlTree> predicate, String message) {
        this.getItemIf(predicate).findFirst().ifPresent(item -> this.report(message));
        return this;
    }

    @Override
    @Nullable
    protected HasTextRange toHighlight() {
        return this.parent;
    }
}

