/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension.visitors;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.extension.visitors.TreeContext;

public class InputFileContext
extends TreeContext {
    private static final String PARSING_ERROR_RULE_KEY = "S2260";
    public final SensorContext sensorContext;
    public final InputFile inputFile;
    private final Set<Integer> raisedIssues = new HashSet<Integer>();

    public InputFileContext(SensorContext sensorContext, InputFile inputFile) {
        this.sensorContext = sensorContext;
        this.inputFile = inputFile;
    }

    public void reportIssue(RuleKey ruleKey, @Nullable TextRange textRange, String message, List<SecondaryLocation> secondaryLocations) {
        if (this.raisedIssues.add(InputFileContext.issueHash(ruleKey, textRange, secondaryLocations))) {
            NewIssue issue = this.sensorContext.newIssue();
            NewIssueLocation issueLocation = issue.newLocation().on(this.inputFile).message(message);
            if (textRange != null && TextRanges.isValidAndNotEmpty(textRange)) {
                issueLocation.at(this.toInputFileRange(textRange));
            }
            issue.forRule(ruleKey).at(issueLocation);
            secondaryLocations.stream().filter(location -> location != null && TextRanges.isValidAndNotEmpty(location.textRange)).forEach(secondary -> issue.addLocation(issue.newLocation().on(this.inputFile).at(this.toInputFileRange(secondary.textRange)).message(secondary.message)));
            issue.save();
        }
    }

    public void reportParseError(String repositoryKey, @Nullable TextPointer location) {
        this.reportAnalysisError("Unable to parse file: " + this.inputFile, location);
        RuleKey parsingErrorRuleKey = RuleKey.of(repositoryKey, PARSING_ERROR_RULE_KEY);
        if (this.sensorContext.activeRules().find(parsingErrorRuleKey) == null) {
            return;
        }
        NewIssue parseError = this.sensorContext.newIssue();
        NewIssueLocation parseErrorLocation = parseError.newLocation().on(this.inputFile).message("A parsing error occurred in this file.");
        Optional.ofNullable(location).map(TextPointer::line).map(this.inputFile::selectLine).ifPresent(parseErrorLocation::at);
        parseError.forRule(parsingErrorRuleKey).at(parseErrorLocation).save();
    }

    public void reportAnalysisError(String message, @Nullable TextPointer location) {
        NewAnalysisError error = this.sensorContext.newAnalysisError();
        error.message(message).onFile(this.inputFile);
        if (location != null) {
            TextPointer pointerLocation = this.inputFile.newPointer(location.line(), location.lineOffset());
            error.at(pointerLocation);
        }
        error.save();
    }

    private org.sonar.api.batch.fs.TextRange toInputFileRange(TextRange textRange) {
        return this.inputFile.newRange(textRange.start().line(), textRange.start().lineOffset(), textRange.end().line(), textRange.end().lineOffset());
    }

    private static int issueHash(RuleKey ruleKey, @Nullable TextRange textRange, List<SecondaryLocation> secondaryLocations) {
        return Objects.hash(ruleKey, textRange, secondaryLocations);
    }
}

