/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.bicep;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.bicep.InterpolatedString;
import org.sonar.iac.arm.tree.api.bicep.interpstring.InterpolatedStringLeftPiece;
import org.sonar.iac.arm.tree.api.bicep.interpstring.InterpolatedStringMiddlePiece;
import org.sonar.iac.arm.tree.api.bicep.interpstring.InterpolatedStringRightPiece;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.api.tree.Tree;

public class InterpolatedStringImpl
extends AbstractArmTreeImpl
implements InterpolatedString {
    private final InterpolatedStringLeftPiece stringLeftPiece;
    private final List<InterpolatedStringMiddlePiece> stringMiddlePieces;
    private final InterpolatedStringRightPiece stringRightPiece;

    public InterpolatedStringImpl(InterpolatedStringLeftPiece stringLeftPiece, List<InterpolatedStringMiddlePiece> stringMiddlePieces, InterpolatedStringRightPiece stringRightPiece) {
        this.stringLeftPiece = stringLeftPiece;
        this.stringMiddlePieces = stringMiddlePieces;
        this.stringRightPiece = stringRightPiece;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> result = new ArrayList<Tree>();
        result.add(this.stringLeftPiece);
        result.addAll(this.stringMiddlePieces);
        result.add(this.stringRightPiece);
        return result;
    }

    @Override
    public ArmTree.Kind getKind() {
        return ArmTree.Kind.INTERPOLATED_STRING;
    }

    @Override
    public String value() {
        return this.stringLeftPiece.value() + this.stringMiddlePieces.stream().map(TextTree::value).collect(Collectors.joining()) + this.stringRightPiece.value();
    }
}

