/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.plugin;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;

public class ArmSettings {
    private static final String ARM_CATEGORY = "AzureResourceManager";
    private static final String GENERAL_SUBCATEGORY = "General";
    protected static final String PROPERTY_KEY_PREFIX = "sonar.azureresourcemanager";
    protected static final String ACTIVATION_KEY = "sonar.azureresourcemanager.activate";
    protected static final String ACTIVATION_DEFAULT_VALUE = "true";
    protected static final String FILE_SUFFIXES_KEY = "sonar.azureresourcemanager.file.suffixes";
    protected static final String FILE_SUFFIXES_DEFAULT_VALUE = ".bicep";
    protected static final String FILE_IDENTIFIER_KEY = "sonar.azureresourcemanager.file.identifier";
    protected static final String FILE_IDENTIFIER_DEFAULT_VALUE = "https://schema.management.azure.com/schemas/";

    private ArmSettings() {
    }

    public static List<PropertyDefinition> getGeneralProperties() {
        return Arrays.asList(PropertyDefinition.builder(ACTIVATION_KEY).index(1).defaultValue(ACTIVATION_DEFAULT_VALUE).name("Activate AzureResourceManager analysis").description("Activate analysis of JSON and Bicep files recognized as ARM files.").type(PropertyType.BOOLEAN).onQualifiers("TRK", new String[0]).category(ARM_CATEGORY).subCategory(GENERAL_SUBCATEGORY).deprecatedKey("sonar.arm.activate").build(), PropertyDefinition.builder(FILE_SUFFIXES_KEY).index(2).defaultValue(FILE_SUFFIXES_DEFAULT_VALUE).name("File Suffixes").description("List of suffixes of AzureResourceManager files to analyze next to JSON.").onQualifiers("TRK", new String[0]).category(ARM_CATEGORY).multiValues(true).subCategory(GENERAL_SUBCATEGORY).build(), PropertyDefinition.builder(FILE_IDENTIFIER_KEY).index(4).defaultValue(FILE_IDENTIFIER_DEFAULT_VALUE).name("JSON Template File Identifier").description("ARM JSON templates without the identifier are excluded from the analysis. The identifier can be anywhere in the file.").onQualifiers("TRK", new String[0]).category(ARM_CATEGORY).subCategory(GENERAL_SUBCATEGORY).deprecatedKey("sonar.arm.file.identifier").build());
    }
}

