/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks.ipaddress;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.TextUtils;

public class IpAddressValidator {
    private static final List<Range> SAFE_RANGES = List.of(IpAddressValidator.ipRange("10.0.0.0", "10.255.255.255"), IpAddressValidator.ipRange("100.64.0.0", "100.127.255.255"), IpAddressValidator.ipRange("169.254.0.0", "169.254.255.255"), IpAddressValidator.ipRange("172.16.0.0", "172.31.255.255"), IpAddressValidator.ipRange("192.0.0.0", "192.0.0.255"), IpAddressValidator.ipRange("192.0.2.0", "192.0.2.255"), IpAddressValidator.ipRange("192.168.0.0", "192.168.255.255"), IpAddressValidator.ipRange("198.18.0.0", "198.19.255.255"), IpAddressValidator.ipRange("198.51.100.0", "198.51.100.255"), IpAddressValidator.ipRange("203.0.113.0", "203.0.113.255"), IpAddressValidator.ipRange("240.0.0.0", "240.255.255.254"));
    private static final String DEFAULT_START_IP = "0.0.0.0";
    private static final String DEFAULT_END_IP = "255.255.255.255";
    @Nullable
    private final ArmTree startIpAddress;
    @Nullable
    private final ArmTree endIpAddress;

    public IpAddressValidator(@Nullable ArmTree startIpAddress, @Nullable ArmTree endIpAddress) {
        this.startIpAddress = startIpAddress;
        this.endIpAddress = endIpAddress;
    }

    public void reportIssueIfPublicIPAddress(CheckContext ctx, String message, String secondaryLocationMessage) {
        ValidationResult validation = this.validateTrees();
        if (validation.isValid()) {
            long startLong = validation.startIp().toLong();
            long endInt = validation.endIp().toLong();
            for (Range safeRange : SAFE_RANGES) {
                if (!safeRange.contains(startLong) || !safeRange.contains(endInt)) continue;
                return;
            }
            this.reportIssue(ctx, message, secondaryLocationMessage);
        }
    }

    private ValidationResult validateTrees() {
        if (this.startIpAddress == null && this.endIpAddress == null) {
            return new ValidationResult(false, null, null);
        }
        String start = IpAddressValidator.valueOrElseDefaultIfStringLiteralOrNull(this.startIpAddress, DEFAULT_START_IP);
        String end = IpAddressValidator.valueOrElseDefaultIfStringLiteralOrNull(this.endIpAddress, DEFAULT_END_IP);
        if (start == null && end == null) {
            return new ValidationResult(false, null, null);
        }
        if (start == null) {
            start = DEFAULT_START_IP;
        }
        if (end == null) {
            end = DEFAULT_END_IP;
        }
        boolean isStartValid = Ip.isAddressValid(start);
        boolean isEndValid = Ip.isAddressValid(end);
        if (!isStartValid && !isEndValid) {
            return new ValidationResult(false, null, null);
        }
        return new ValidationResult(true, isStartValid ? new Ip(start) : new Ip(DEFAULT_START_IP), isEndValid ? new Ip(end) : new Ip(DEFAULT_END_IP));
    }

    private void reportIssue(CheckContext ctx, String message, String secondaryLocationMessage) {
        ArmTree secondary;
        ArmTree tree = this.startIpAddress != null ? this.startIpAddress : this.endIpAddress;
        ArmTree armTree = secondary = this.startIpAddress != null && this.endIpAddress != null ? this.endIpAddress : null;
        if (secondary != null) {
            SecondaryLocation secondaryLocation = new SecondaryLocation(secondary, secondaryLocationMessage);
            ctx.reportIssue((HasTextRange)tree, message, List.of(secondaryLocation));
        } else {
            ctx.reportIssue(tree, message);
        }
    }

    @CheckForNull
    private static String valueOrElseDefaultIfStringLiteralOrNull(@Nullable ArmTree tree, String defaultIpAddress) {
        if (tree != null && tree.is(ArmTree.Kind.STRING_LITERAL, ArmTree.Kind.STRING_COMPLETE)) {
            return TextUtils.getValue(tree).orElse(defaultIpAddress);
        }
        return null;
    }

    private static Range ipRange(String startIp, String endIp) {
        return new Range(new Ip(startIp).toLong(), new Ip(endIp).toLong());
    }

    static class ValidationResult {
        private final boolean valid;
        private final Ip startIp;
        private final Ip endIp;

        ValidationResult(boolean valid, @Nullable Ip startIp, @Nullable Ip endIp) {
            this.valid = valid;
            this.startIp = startIp;
            this.endIp = endIp;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Ip startIp() {
            return this.startIp;
        }

        public Ip endIp() {
            return this.endIp;
        }
    }

    static class Ip {
        private static final int BASE3 = (int)Math.pow(256.0, 3.0);
        private static final int BASE2 = (int)Math.pow(256.0, 2.0);
        private static final int BASE1 = 256;
        private final String address;

        Ip(String address) {
            this.address = address;
        }

        static boolean isAddressValid(String text) {
            if (text.length() < 7 || text.length() > 15) {
                return false;
            }
            String[] split = text.split("\\.");
            if (split.length != 4) {
                return false;
            }
            for (String s : split) {
                try {
                    int x = Integer.parseInt(s);
                    if (x >= 0 && x <= 255) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }

        long toLong() {
            String[] split = this.address.split("\\.");
            long x1 = Long.parseLong(split[0]);
            long x2 = Long.parseLong(split[1]);
            long x3 = Long.parseLong(split[2]);
            long x4 = Long.parseLong(split[3]);
            return x1 * (long)BASE3 + x2 * (long)BASE2 + x3 * 256L + x4;
        }
    }

    static class Range {
        private final long startInclusive;
        private final long endInclusive;

        public Range(long startInclusive, long endInclusive) {
            this.startInclusive = startInclusive;
            this.endInclusive = endInclusive;
        }

        public boolean contains(long x) {
            return x >= this.startInclusive && x <= this.endInclusive;
        }
    }
}

