/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checkdsl;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.checkdsl.ContextualMap;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.checkdsl.ContextualTree;
import org.sonar.iac.common.checks.TextUtils;

public final class ContextualResource
extends ContextualMap<ContextualResource, ResourceDeclaration> {
    public final String type;
    public final String version;

    private ContextualResource(CheckContext ctx, @Nullable ResourceDeclaration tree, String type, @Nullable ContextualMap<?, ?> parent) {
        super(ctx, tree, (String)Optional.ofNullable(tree).map(ResourceDeclaration::name).map(TextTree::value).orElse(null), (ContextualTree<?, ?>)parent);
        this.type = type;
        this.version = Optional.ofNullable(tree).map(ResourceDeclaration::version).map(TextTree::value).orElse("");
    }

    public static ContextualResource fromPresent(CheckContext ctx, ResourceDeclaration tree) {
        return new ContextualResource(ctx, tree, tree.type().value(), null);
    }

    public static ContextualResource fromPresent(CheckContext ctx, ResourceDeclaration tree, String resourceType) {
        return new ContextualResource(ctx, tree, resourceType, null);
    }

    public static ContextualResource fromAbsent(CheckContext ctx, String resourceType, ContextualMap<?, ?> parent) {
        return new ContextualResource(ctx, null, resourceType, parent);
    }

    public boolean isReferencingResource() {
        return this.tree != null && ((ResourceDeclaration)this.tree).existing() != null;
    }

    @Override
    @CheckForNull
    protected HasTextRange toHighlight() {
        return this.tree != null ? ((ResourceDeclaration)this.tree).type() : null;
    }

    public ContextualResource childResourceBy(String type, Predicate<ResourceDeclaration> predicate) {
        return Optional.ofNullable((ResourceDeclaration)this.tree).flatMap(resource -> resource.childResources().stream().filter(it -> TextUtils.isValue(it.type(), type).isTrue()).filter(predicate).findFirst()).map(it -> new ContextualResource(this.ctx, (ResourceDeclaration)it, it.type().value(), this)).orElse(ContextualResource.fromAbsent(this.ctx, type, this));
    }
}

