/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.CommandInstruction;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.Flag;
import org.sonar.iac.docker.tree.api.HasArguments;

public final class CheckUtils {
    private CheckUtils() {
    }

    public static List<ArgumentResolution> resolveInstructionArguments(HasArguments instructionWithArguments) {
        return instructionWithArguments.arguments().stream().map(ArgumentResolution::ofWithoutStrippingQuotes).collect(Collectors.toList());
    }

    public static String getFileExtension(String name) {
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf + 1);
    }

    public static Optional<Flag> getParamByName(Collection<Flag> params, String name) {
        return params.stream().filter(param -> name.equals(param.name())).findFirst();
    }

    public static <T extends CommandInstruction> BiConsumer<CheckContext, T> ignoringHeredoc(BiConsumer<CheckContext, T> visitor) {
        return (ctx, commandInstruction) -> {
            if (DockerTree.Kind.HEREDOCUMENT != commandInstruction.getKindOfArgumentList()) {
                visitor.accept((CheckContext)ctx, (Object)commandInstruction);
            }
        };
    }

    public static <T extends CommandInstruction> BiConsumer<CheckContext, T> ignoringExecForm(BiConsumer<CheckContext, T> visitor) {
        return (ctx, commandInstruction) -> {
            if (DockerTree.Kind.EXEC_FORM != commandInstruction.getKindOfArgumentList()) {
                visitor.accept((CheckContext)ctx, (Object)commandInstruction);
            }
        };
    }
}

