/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension;

import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.iac.common.extension.ProvideLanguageKey;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

public abstract class IacRulesDefinition
implements RulesDefinition,
ProvideLanguageKey {
    public static final String REPOSITORY_NAME = "SonarAnalyzer";
    private static final String RESOURCE_FOLDER_FORMAT = "org/sonar/l10n/%1$s/rules/%1$s";
    public static final String SONAR_WAY_FILE = "/Sonar_way_profile.json";
    private SonarRuntime runtime;

    protected IacRulesDefinition(SonarRuntime runtime) {
        this.runtime = runtime;
    }

    protected abstract List<Class<?>> checks();

    public void define(RulesDefinition.Context context) {
        String languageKey = this.languageKey();
        RulesDefinition.NewRepository repository = context.createRepository(languageKey, languageKey).setName(REPOSITORY_NAME);
        String resourceFolder = String.format(RESOURCE_FOLDER_FORMAT, languageKey);
        String defaultProfilePath = resourceFolder + SONAR_WAY_FILE;
        RuleMetadataLoader metadataLoader = new RuleMetadataLoader(resourceFolder, defaultProfilePath, this.runtime);
        metadataLoader.addRulesByAnnotatedClass(repository, this.checks());
        repository.done();
    }
}

