/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checkdsl;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checkdsl.ContextualTree;

public class ContextualListTree<S extends ContextualListTree<S, T, E>, T extends Tree, E extends Tree>
extends ContextualTree<S, T> {
    protected final List<E> items;

    protected ContextualListTree(CheckContext ctx, @Nullable T tree, String name, @Nullable ContextualTree<?, ?> parent, List<E> items) {
        super(ctx, tree, name, parent);
        this.items = items;
    }

    public S reportItemIf(Predicate<E> predicate, String message, SecondaryLocation ... secondaryLocations) {
        this.items.stream().filter(predicate).forEach(item -> this.ctx.reportIssue((HasTextRange)item, message, List.of(secondaryLocations)));
        return (S)this;
    }

    public S reportIfEmpty(String message, SecondaryLocation ... secondaryLocations) {
        if (this.isEmpty()) {
            this.report(message, secondaryLocations);
        }
        return (S)this;
    }

    public Stream<E> getItemIf(Predicate<E> predicate) {
        return this.items.stream().filter(predicate);
    }

    public boolean isEmpty() {
        return this.tree != null && this.items.isEmpty();
    }
}

