/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.List;
import java.util.function.Consumer;
import org.sonar.iac.arm.checkdsl.ContextualArray;
import org.sonar.iac.arm.checkdsl.ContextualMap;
import org.sonar.iac.arm.checkdsl.ContextualObject;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.ipaddress.IpAddressValidator;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.common.api.tree.HasProperties;
import org.sonar.iac.common.api.tree.Tree;

class PublicNetworkAccessIpRangeCheckPart
extends AbstractArmResourceCheck {
    private static final String PUBLIC_IP_ADDRESS_MESSAGE = "Make sure that allowing public IP addresses is safe here.";
    private static final String PUBLIC_IP_ADDRESS_MESSAGE_SECONDARY_LOCATION = "and here";
    private static final List<String> PUBLIC_IP_ADDRESS_RANGE_TYPES = List.of("Microsoft.DBForPostgreSql/flexibleServers/firewallRules", "Microsoft.DBforMariaDB/servers/firewallRules", "Microsoft.DBforMySQL/flexibleServers/firewallRules", "Microsoft.DBforMySQL/servers/firewallRules", "Microsoft.DBforPostgreSQL/flexibleServers/firewallRules", "Microsoft.DBforPostgreSQL/serverGroupsv2/firewallRules", "Microsoft.DBforPostgreSQL/servers/firewallRules", "Microsoft.DataLakeAnalytics/accounts/firewallRules", "Microsoft.DataLakeStore/accounts/firewallRules", "Microsoft.DocumentDB/mongoClusters/firewallRules", "Microsoft.Sql/servers/firewallRules", "Microsoft.Synapse/workspaces/firewallRules");
    private static final List<String> PUBLIC_IP_ADDRESS_RANGE_IN_FIREWALL_RULES_TYPES = List.of("Microsoft.Blockchain/blockchainMembers", "Microsoft.Blockchain/blockchainMembers/transactionNodes");
    private static final List<String> PUBLIC_IP_ADDRESS_RANGE_IN_PROPERTIES_FIREWALL_RULES_TYPES = List.of("Microsoft.DataLakeAnalytics/accounts", "Microsoft.DataLakeStore/accounts");

    PublicNetworkAccessIpRangeCheckPart() {
    }

    @Override
    protected void registerResourceConsumer() {
        this.register(PUBLIC_IP_ADDRESS_RANGE_TYPES, PublicNetworkAccessIpRangeCheckPart::checkIpRange);
        this.register(PUBLIC_IP_ADDRESS_RANGE_IN_FIREWALL_RULES_TYPES, PublicNetworkAccessIpRangeCheckPart.checkIpRangeInFirewallRules());
        this.register(PUBLIC_IP_ADDRESS_RANGE_IN_PROPERTIES_FIREWALL_RULES_TYPES, PublicNetworkAccessIpRangeCheckPart.checkIpRangeInFirewallRulesProperties());
    }

    private static <S extends ContextualMap<S, T>, T extends HasProperties & Tree> void checkIpRange(ContextualMap<S, T> resource) {
        ContextualProperty startIpAddress = resource.property("startIpAddress");
        ContextualProperty endIpAddress = resource.property("endIpAddress");
        Expression startValue = startIpAddress.valueOrNull();
        Expression endValue = endIpAddress.valueOrNull();
        IpAddressValidator validator = new IpAddressValidator(startValue, endValue);
        validator.reportIssueIfPublicIPAddress(resource.ctx, PUBLIC_IP_ADDRESS_MESSAGE, PUBLIC_IP_ADDRESS_MESSAGE_SECONDARY_LOCATION);
    }

    private static Consumer<ContextualResource> checkIpRangeInFirewallRules() {
        return resource -> {
            ContextualArray list = resource.list("firewallRules");
            list.objects().forEach(PublicNetworkAccessIpRangeCheckPart::checkIpRange);
        };
    }

    private static Consumer<ContextualResource> checkIpRangeInFirewallRulesProperties() {
        return resource -> {
            ContextualArray list = resource.list("firewallRules");
            list.objects().forEach(rule -> {
                ContextualObject properties = rule.object("properties");
                PublicNetworkAccessIpRangeCheckPart.checkIpRange(properties);
            });
        };
    }
}

