/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.common.api.checks.SecondaryLocation;

@Rule(key="S6381")
public class HighPrivilegedRoleCheck
extends AbstractArmResourceCheck {
    private static final String MESSAGE = "Make sure that assigning the %s role is safe here.";
    private static final String CONTRIBUTOR_GUID = "b24988ac-6180-42a0-ab88-20f7382dd24c";
    private static final String OWNER_GUID = "8e3af657-a8ff-443c-a75c-2fe8c4bcb635";
    private static final String USER_ACCESS_ADMINISTRATOR_GUID = "18d7d88d-d35e-4fb5-a5c3-7773c20a72d9";

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Authorization/roleAssignments", HighPrivilegedRoleCheck.checkHighPrivilegedRole());
    }

    private static Consumer<ContextualResource> checkHighPrivilegedRole() {
        return resource -> ((ContextualProperty)((ContextualProperty)resource.property("roleDefinitionId").reportIf(HighPrivilegedRoleCheck.isContributor(), String.format(MESSAGE, "Contributor"), new SecondaryLocation[0])).reportIf(HighPrivilegedRoleCheck.isOwner(), String.format(MESSAGE, "Owner"), new SecondaryLocation[0])).reportIf(HighPrivilegedRoleCheck.isUserAccessAdministrator(), String.format(MESSAGE, "User Access Administrator"), new SecondaryLocation[0]);
    }

    private static Predicate<Expression> isContributor() {
        return CheckUtils.containsRecursively(CONTRIBUTOR_GUID);
    }

    private static Predicate<Expression> isOwner() {
        return CheckUtils.containsRecursively(OWNER_GUID);
    }

    private static Predicate<Expression> isUserAccessAdministrator() {
        return CheckUtils.containsRecursively(USER_ACCESS_ADMINISTRATOR_GUID);
    }
}

