/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.reports.tflint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rules.RuleType;
import org.sonar.iac.common.reports.AbstractJsonReportImporter;
import org.sonar.iac.common.reports.ReportImporterException;
import org.sonar.iac.common.warnings.AnalysisWarningsWrapper;
import org.sonar.iac.terraform.plugin.TFLintRulesDefinition;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class TFLintImporter
extends AbstractJsonReportImporter {
    private static final Logger LOG = LoggerFactory.getLogger(TFLintImporter.class);
    private static final String MESSAGE_PREFIX = "TFLint report importing: ";
    private static final Pattern FILENAME_PATTERN = Pattern.compile(":\\s([^*&%:]+):(\\d+),(\\d+)-(\\d+):");

    public TFLintImporter(SensorContext context, AnalysisWarningsWrapper analysisWarnings) {
        super(context, analysisWarnings, MESSAGE_PREFIX);
    }

    @Override
    protected JSONArray parseFileAsArray(File reportFile) throws IOException, ParseException {
        Object parsedJson = jsonParser.parse(Files.newBufferedReader(reportFile.toPath()));
        JSONArray issuesArray = (JSONArray)((JSONObject)parsedJson).get("issues");
        JSONArray errorsArray = (JSONArray)((JSONObject)parsedJson).get("errors");
        issuesArray.addAll(errorsArray);
        return issuesArray;
    }

    @Override
    protected NewExternalIssue toExternalIssue(JSONObject issueJson) {
        NewExternalIssue externalIssue;
        String severity;
        JSONObject rule = (JSONObject)issueJson.get("rule");
        RuleType type = RuleType.CODE_SMELL;
        Long effortInMinutes = 5L;
        if (rule == null) {
            severity = (String)issueJson.get("severity");
            externalIssue = this.context.newExternalIssue().ruleId("tflint.error");
            externalIssue.at(this.errorLocation(issueJson, externalIssue));
        } else {
            String ruleId = (String)rule.get("name");
            severity = (String)rule.get("severity");
            if (TFLintRulesDefinition.RULE_LOADER.ruleKeys().contains(ruleId)) {
                type = TFLintRulesDefinition.RULE_LOADER.ruleType(ruleId);
                effortInMinutes = TFLintRulesDefinition.RULE_LOADER.ruleConstantDebtMinutes(ruleId);
            } else {
                LOG.trace("{} No rule definition for rule id: {}", (Object)MESSAGE_PREFIX, (Object)ruleId);
            }
            externalIssue = this.context.newExternalIssue().ruleId(ruleId);
            externalIssue.at(this.issueLocation(issueJson, externalIssue));
        }
        externalIssue.type(type).engineId("tflint").severity(TFLintImporter.severity(severity)).remediationEffortMinutes(effortInMinutes);
        return externalIssue;
    }

    private NewIssueLocation issueLocation(JSONObject issueJson, NewExternalIssue externalIssue) {
        JSONObject range = (JSONObject)issueJson.get("range");
        String filename = (String)range.get("filename");
        InputFile inputFile = this.inputFile(filename);
        JSONObject start = (JSONObject)range.get("start");
        int startLine = TFLintImporter.asInt(start.get("line"));
        int startColumn = TFLintImporter.asInt(start.get("column"));
        JSONObject end = (JSONObject)range.get("end");
        int endLine = TFLintImporter.asInt(end.get("line"));
        int endColumn = TFLintImporter.asInt(end.get("column"));
        TextRange textRange = inputFile.newRange(startLine, startColumn - 1, endLine, endColumn - 1);
        String message = (String)issueJson.get("message");
        return externalIssue.newLocation().message(message).on((InputComponent)inputFile).at(textRange);
    }

    private NewIssueLocation errorLocation(JSONObject issueJson, NewExternalIssue externalIssue) {
        TextRange textRange;
        String message = (String)issueJson.get("message");
        Matcher matcher = FILENAME_PATTERN.matcher(message);
        if (!matcher.find()) {
            throw new ReportImporterException("Can't extract filename from error message");
        }
        String filename = matcher.group(1);
        int startLine = Integer.parseInt(matcher.group(2));
        int startColumn = Integer.parseInt(matcher.group(3));
        int endLineOffset = Integer.parseInt(matcher.group(4));
        InputFile inputFile = this.inputFile(filename);
        try {
            textRange = inputFile.newRange(startLine, startColumn - 1, startLine, endLineOffset - 1);
        }
        catch (IllegalArgumentException e) {
            textRange = inputFile.selectLine(startLine);
        }
        return externalIssue.newLocation().message(message).on((InputComponent)inputFile).at(textRange);
    }

    private static Severity severity(String severity) {
        String text = severity.toUpperCase(Locale.ENGLISH);
        if ("WARNING".equals(text)) {
            text = "MINOR";
        }
        if ("ERROR".equals(text)) {
            text = "BLOCKER";
        }
        try {
            return Severity.valueOf((String)text);
        }
        catch (IllegalArgumentException e) {
            return Severity.MINOR;
        }
    }
}

