/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6412")
public class UnversionedStorageBucketCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure using an unversioned GCS bucket is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting %s will disable versioning for GCS bucket. Ensure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("google_storage_bucket", (ResourceSymbol resource) -> {
            if (resource.block("retention_policy").isAbsent()) {
                ((BlockSymbol)resource.block("versioning").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0])).attribute("enabled").reportIf(ExpressionPredicate.isFalse(), MESSAGE, new SecondaryLocation[0]);
            }
        });
    }
}

