/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class GcpDisabledLoggingCheckPart
extends AbstractNewResourceCheck {
    private static final List<String> DATABASE_FLAGS = List.of("log_connections", "log_disconnections", "log_checkpoints", "log_lock_waits");

    @Override
    protected void registerResourceConsumer() {
        this.register("google_storage_bucket", (ResourceSymbol resource) -> resource.block("logging").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("google_compute_region_backend_service", (ResourceSymbol resource) -> ((BlockSymbol)resource.block("log_config").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0])).attribute("enable").reportIf(ExpressionPredicate.isFalse(), "Make sure that disabling logging is safe here.", new SecondaryLocation[0]));
        this.register("google_compute_subnetwork", (ResourceSymbol resource) -> resource.block("log_config").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("google_container_cluster", (ResourceSymbol resource) -> resource.attribute("logging_service").reportIf(ExpressionPredicate.equalTo("none"), "Make sure that disabling logging is safe here.", new SecondaryLocation[0]));
        this.register("google_sql_database_instance", (ResourceSymbol resource) -> {
            BlockSymbol settings = (BlockSymbol)resource.block("settings").reportIfAbsent("Omitting %s makes logs incomplete. Make sure it is safe here.", new SecondaryLocation[0]);
            ArrayList<String> requiredFlags = new ArrayList<String>(DATABASE_FLAGS);
            settings.blocks("database_flags").forEach(flags -> Optional.ofNullable(flags.attribute("name").asString()).filter(DATABASE_FLAGS::contains).ifPresent(name -> {
                requiredFlags.remove(name);
                flags.attribute("value").reportIf(ExpressionPredicate.notEqualTo("on"), "Make sure that disabling logging is safe here.", new SecondaryLocation[0]);
            }));
            if (!requiredFlags.isEmpty()) {
                settings.report(String.format("Omitting %s makes logs incomplete. Make sure it is safe here.", "database_flags." + (String)requiredFlags.get(0)), new SecondaryLocation[0]);
            }
        });
    }
}

