/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6413")
public class ShortLogRetentionCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure that defining a short log retention duration is safe here.";
    private static final int FALLBACK_DEFAULT = 30;
    private static final int MIN_DEFAULT = 14;
    @RuleProperty(key="minimum_log_retention_days", defaultValue="14")
    int minimumLogRetentionDays = 14;

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("google_logging_project_bucket_config", "google_logging_billing_account_bucket_config", "google_logging_organization_bucket_config", "google_logging_folder_bucket_config"), (ResourceSymbol resource) -> {
            AttributeSymbol retention = (AttributeSymbol)resource.attribute("retention_days").reportIf(this.lessThanMinimumOrFallback(), MESSAGE, new SecondaryLocation[0]);
            if (retention.isAbsent() && 30 < this.minimumLogRetentionDays) {
                resource.report(MESSAGE, new SecondaryLocation[0]);
            }
        });
        this.register(List.of("azurerm_mssql_server_extended_auditing_policy", "azurerm_mssql_database_extended_auditing_policy"), (ResourceSymbol resource) -> resource.consume(this::checkRetentionInDays));
        this.register("azurerm_app_service", (ResourceSymbol resource) -> {
            BlockSymbol logs = resource.block("logs");
            Set.of(logs.block("http_logs").block("azure_blob_storage"), logs.block("http_logs").block("file_system"), logs.block("application_logs").block("azure_blob_storage")).forEach(block -> block.consume(this::checkRetentionInDays));
        });
        this.register("azurerm_firewall_policy", (ResourceSymbol resource) -> resource.block("insights").consume(this::checkRetentionInDays));
        this.register(Set.of("azurerm_monitor_log_profile", "azurerm_network_watcher_flow_log"), (ResourceSymbol resource) -> {
            BlockSymbol retentionPolicy = resource.block("retention_policy");
            AttributeSymbol enabled = retentionPolicy.attribute("enabled");
            if (enabled.is(ExpressionPredicate.isFalse())) {
                enabled.report("Make sure that disabling retention policy is safe here.", new SecondaryLocation[0]);
                return;
            }
            retentionPolicy.attribute("days").reportIf(this.lessThanMinimumButNotZero(), MESSAGE, new SecondaryLocation[0]);
        });
        this.register(List.of("azurerm_sql_server", "azurerm_mysql_server", "azurerm_postgresql_server"), (ResourceSymbol resource) -> resource.block("threat_detection_policy").attribute("retention_days").reportIf(this.lessThanMinimumButNotZero(), MESSAGE, new SecondaryLocation[0]));
    }

    private void checkRetentionInDays(BlockSymbol block) {
        block.attribute("retention_in_days").reportIf(this.lessThanMinimumButNotZero(), MESSAGE, new SecondaryLocation[0]);
    }

    private Predicate<ExpressionTree> lessThanMinimumButNotZero() {
        return ExpressionPredicate.lessThan(this.minimumLogRetentionDays).and(ExpressionPredicate.notEqualTo("0"));
    }

    private Predicate<ExpressionTree> lessThanMinimumOrFallback() {
        return expression -> TextUtils.getIntValue(expression).map(retention -> retention == 0 ? 30 : retention).filter(retention -> retention < this.minimumLogRetentionDays).isPresent();
    }
}

