/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public abstract class AbstractNewResourceCheck
implements IacCheck {
    private final Map<String, List<Consumer<ResourceSymbol>>> resourceConsumers = new HashMap<String, List<Consumer<ResourceSymbol>>>();

    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, this::provideResource);
        this.registerResourceConsumer();
    }

    protected abstract void registerResourceConsumer();

    protected void provideResource(CheckContext ctx, BlockTree blockTree) {
        if (AbstractNewResourceCheck.isResource(blockTree)) {
            ResourceSymbol resource = ResourceSymbol.fromPresent(ctx, blockTree);
            if (this.resourceConsumers.containsKey(resource.type)) {
                this.resourceConsumers.get(resource.type).forEach(consumer -> consumer.accept(resource));
            }
        }
    }

    protected void register(String resourceName, Consumer<ResourceSymbol> consumer) {
        this.resourceConsumers.computeIfAbsent(resourceName, i -> new ArrayList()).add(consumer);
    }

    protected void register(Collection<String> resourceNames, Consumer<ResourceSymbol> consumer) {
        resourceNames.forEach(resourceName -> this.register((String)resourceName, consumer));
    }

    public static boolean isResource(BlockTree blockTree) {
        return "resource".equals(blockTree.key().value());
    }

    public static boolean isDataOfType(BlockTree blockTree, String dataType) {
        return "data".equals(blockTree.key().value()) && dataType.equals(AbstractNewResourceCheck.resourceType(blockTree));
    }

    @CheckForNull
    public static String resourceType(BlockTree tree) {
        return tree.labels().isEmpty() ? null : tree.labels().get(0).value();
    }
}

