/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;

@Rule(key="S6429")
public class DockerSocketCheck
extends AbstractKubernetesObjectCheck {
    private static final String MESSAGE = "Make sure exposing the Docker socket is safe here.";
    private static final String DOCKER_SOCK_PATH = "/var/run/docker.sock";
    private static final String HOST_PATH = "hostPath";

    @Override
    void registerObjectCheck() {
        this.register("Pod", (BlockObject pod) -> pod.blocks("volumes").forEach(container -> container.block(HOST_PATH).attribute("path").reportIfValue(TreePredicates.isEqualTo(DOCKER_SOCK_PATH), MESSAGE)));
        this.register("PersistentVolume", (BlockObject perVolu) -> perVolu.block(HOST_PATH).attribute("path").reportIfValue(TreePredicates.isEqualTo(DOCKER_SOCK_PATH), MESSAGE));
        this.register(List.of("DaemonSet", "Deployment", "Job", "ReplicaSet", "ReplicationController", "StatefulSet"), (BlockObject obj) -> obj.block("template").block("spec").blocks("volumes").forEach(container -> container.block(HOST_PATH).attribute("path").reportIfValue(TreePredicates.isEqualTo(DOCKER_SOCK_PATH), MESSAGE)));
    }
}

