/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.iac.docker.checks.utils.command.CommandPredicate;
import org.sonar.iac.docker.checks.utils.command.OptionPredicate;
import org.sonar.iac.docker.checks.utils.command.PredicateContext;
import org.sonar.iac.docker.checks.utils.command.SingularPredicate;
import org.sonar.iac.docker.symbols.ArgumentResolution;

public class MultipleUnorderedOptionsPredicate
implements CommandPredicate {
    final List<OptionPredicate> options;
    final boolean shouldSupportAnyMatch;

    public MultipleUnorderedOptionsPredicate(List<OptionPredicate> options) {
        this.options = options;
        this.shouldSupportAnyMatch = true;
    }

    public boolean isShouldSupportAnyMatch() {
        return this.shouldSupportAnyMatch;
    }

    public OptionPredicate calculateAnyOptionMatchingExceptExpected() {
        Predicate noFlagFromExpectedOptions = this.options.stream().map(option -> option.flagPredicate.predicate.negate()).reduce(s -> s.startsWith("-"), Predicate::and);
        SingularPredicate anyFlagPredicate = new SingularPredicate(noFlagFromExpectedOptions, CommandPredicate.Type.ZERO_OR_MORE);
        SingularPredicate anyValuePredicate = new SingularPredicate(s -> !s.startsWith("-") && !s.startsWith("&&"), CommandPredicate.Type.ZERO_OR_MORE);
        return new OptionPredicate(anyFlagPredicate, anyValuePredicate);
    }

    @Override
    public boolean hasType(CommandPredicate.Type ... types) {
        for (OptionPredicate optionPredicate : this.options) {
            if (!optionPredicate.hasType(types)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void match(PredicateContext context) {
        HashSet<OptionPredicate> fulfilledOptions = new HashSet<OptionPredicate>();
        ArrayList<OptionPredicate> workingSet = new ArrayList<OptionPredicate>(this.options);
        long expectedMatches = workingSet.stream().filter(optionPredicate -> optionPredicate.hasType(CommandPredicate.Type.MATCH)).count();
        OptionPredicate anyOptionExceptExpectedPredicate = this.calculateAnyOptionMatchingExceptExpected();
        boolean anythingMatched = true;
        while (anythingMatched && !workingSet.isEmpty()) {
            if (context.areNoArgumentsToHandle()) {
                context.detectCurrentPredicateAgain();
                return;
            }
            anythingMatched = this.matchExpectedOrAnyOption(context, fulfilledOptions, workingSet, anyOptionExceptExpectedPredicate);
        }
        if ((long)fulfilledOptions.size() != expectedMatches) {
            context.setStatus(PredicateContext.Status.ABORT);
        }
    }

    public boolean matchExpectedOrAnyOption(PredicateContext context, Set<OptionPredicate> fulfilledOptions, List<OptionPredicate> workingSet, OptionPredicate anyOptionExceptExpectedPredicate) {
        boolean anythingMatched = false;
        int previousNumberOfCommandArguments = context.numberOfArgumentsToReport();
        Iterator<OptionPredicate> iterator = workingSet.iterator();
        while (iterator.hasNext() && !anythingMatched) {
            OptionPredicate option = iterator.next();
            ArgumentResolution argumentResolution = context.getNextArgumentToHandle();
            option.match(context);
            if (context.is(PredicateContext.Status.FOUND_NO_PREDICATE_MATCH)) {
                context.getArgumentStack().addFirst(argumentResolution);
            }
            if (context.is(PredicateContext.Status.ABORT)) {
                return false;
            }
            if (context.is(PredicateContext.Status.FOUND_NO_PREDICATE_MATCH) || previousNumberOfCommandArguments == context.numberOfArgumentsToReport()) continue;
            iterator.remove();
            fulfilledOptions.add(option);
            anythingMatched = true;
        }
        if (!anythingMatched && ((MultipleUnorderedOptionsPredicate)context.getCurrentPredicate()).isShouldSupportAnyMatch()) {
            anyOptionExceptExpectedPredicate.match(context);
            if (previousNumberOfCommandArguments != context.numberOfArgumentsToReport()) {
                anythingMatched = true;
            }
        }
        return anythingMatched;
    }
}

