/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml;

import java.util.List;
import java.util.function.Predicate;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.tree.YamlTree;

public class TreePredicates {
    private static final List<String> STRINGS_CONSIDERED_AS_EMPTY = List.of("", "~", "[]", "null");

    private TreePredicates() {
    }

    public static Predicate<YamlTree> isTrue() {
        return TextUtils::isValueTrue;
    }

    public static Predicate<YamlTree> isEqualTo(String parameter) {
        return t -> TextUtils.isValue(t, parameter).isTrue();
    }

    public static Predicate<YamlTree> isSet() {
        return t -> TextUtils.matchesValue(t, value -> !STRINGS_CONSIDERED_AS_EMPTY.contains(value)).isTrue();
    }

    public static Predicate<YamlTree> startsWith(List<String> strings) {
        return t -> strings.stream().anyMatch(string -> TextUtils.matchesValue(t, value -> value.startsWith((String)string)).isTrue());
    }
}

