/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.parser;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.api.typed.Input;
import java.util.ArrayList;
import java.util.List;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.impl.CommentImpl;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;

public class NodeBuilderUtils {
    public static final char BYTE_ORDER_MARK = '\ufeff';

    private NodeBuilderUtils() {
    }

    public static List<Comment> createComments(List<Trivia> trivias) {
        ArrayList<Comment> result = new ArrayList<Comment>();
        for (Trivia trivia : trivias) {
            Token triviaToken = trivia.getToken();
            String text = triviaToken.getValue();
            TextRange range = TextRanges.range(triviaToken.getLine(), triviaToken.getColumn(), text);
            result.add(new CommentImpl(text, NodeBuilderUtils.getCommentContent(text), range));
        }
        return result;
    }

    private static String getCommentContent(String comment) {
        if (comment.startsWith("//")) {
            return comment.substring(2);
        }
        if (comment.startsWith("#")) {
            return comment.substring(1);
        }
        return comment.substring(2, comment.length() - 2);
    }

    public static TextRange tokenRange(Input input, int startIndex, String value) {
        int[] lineAndColumn = input.lineAndColumnAt(startIndex);
        char[] fileChars = input.input();
        boolean hasByteOrderMark = fileChars.length > 0 && fileChars[0] == '\ufeff';
        int column = NodeBuilderUtils.applyByteOrderMark(lineAndColumn[1], hasByteOrderMark) - 1;
        return TextRanges.range(lineAndColumn[0], column, value);
    }

    private static int applyByteOrderMark(int column, boolean hasByteOrderMark) {
        return hasByteOrderMark ? column - 1 : column;
    }
}

