/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks.policy;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpRestrictedAdminAccessCheckUtils {
    public static final String MESSAGE = "Restrict IP addresses authorized to access administration services.";
    public static final String ALL_IPV4 = "0.0.0.0/0";
    public static final String ALL_IPV6 = "::/0";
    public static final int SSH_PORT = 22;
    public static final int RDP_PORT = 3389;
    public static final Set<String> SENSITIVE_PORTS = Set.of("*", String.valueOf(22), String.valueOf(3389));
    private static final Pattern PORT_RANGE_PATTERN = Pattern.compile("^(?<from>\\d{1,5})-(?<to>\\d{1,5})$");

    private IpRestrictedAdminAccessCheckUtils() {
    }

    public static boolean rangeContainsSshOrRdpPort(String range) {
        if (range.contains("-")) {
            Matcher m = PORT_RANGE_PATTERN.matcher(range);
            if (m.find()) {
                return IpRestrictedAdminAccessCheckUtils.rangeContainsSshOrRdpPort(IpRestrictedAdminAccessCheckUtils.portFromMatch(m, "from"), IpRestrictedAdminAccessCheckUtils.portFromMatch(m, "to"));
            }
            return false;
        }
        return SENSITIVE_PORTS.contains(range);
    }

    private static int portFromMatch(Matcher m, String group) {
        return Integer.parseInt(m.group(group));
    }

    public static boolean rangeContainsSshOrRdpPort(int from, int to) {
        return 22 >= from && 22 <= to || 3389 >= from && 3389 <= to;
    }
}

