/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.api.tree.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.impl.TextPointer;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonarsource.analyzer.commons.TokenLocation;

public class TextRanges {
    private static final Supplier<IllegalArgumentException> MERGE_EXCEPTION_SUPPLIER = () -> new IllegalArgumentException("Can't merge 0 ranges");

    private TextRanges() {
    }

    public static TextRange range(int startLine, int startColumn, int endLine, int endColumn) {
        return new TextRange(new TextPointer(startLine, startColumn), new TextPointer(endLine, endColumn));
    }

    public static TextRange range(int line, int column, String value) {
        TokenLocation location = new TokenLocation(line, column, value);
        TextPointer startPointer = new TextPointer(location.startLine(), location.startLineOffset());
        TextPointer endPointer = new TextPointer(location.endLine(), location.endLineOffset());
        return new TextRange(startPointer, endPointer);
    }

    public static TextRange merge(List<TextRange> ranges) {
        return new TextRange(ranges.stream().map(TextRange::start).min(Comparator.naturalOrder()).orElseThrow(MERGE_EXCEPTION_SUPPLIER), ranges.stream().map(TextRange::end).max(Comparator.naturalOrder()).orElseThrow(MERGE_EXCEPTION_SUPPLIER));
    }

    public static TextRange mergeElementsWithTextRange(List<? extends HasTextRange> elementsWithTextRange) {
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>();
        for (HasTextRange hasTextRange : elementsWithTextRange) {
            textRanges.add(hasTextRange.textRange());
        }
        return TextRanges.merge(textRanges);
    }

    public static boolean isValidAndNotEmpty(TextRange range) {
        return range.end().compareTo(range.start()) > 0;
    }
}

