/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.api.tree.impl;

import java.util.Objects;
import org.sonar.iac.common.api.tree.impl.TextPointer;

public class TextRange {
    private final TextPointer start;
    private final TextPointer end;

    public TextRange(TextPointer start, TextPointer end) {
        this.start = start;
        this.end = end;
    }

    public TextPointer start() {
        return this.start;
    }

    public TextPointer end() {
        return this.end;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TextRange otherRange = (TextRange)other;
        return Objects.equals(this.start, otherRange.start) && Objects.equals(this.end, otherRange.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "[" + this.start.line() + ":" + this.start.lineOffset() + "/" + this.end.line() + ":" + this.end.lineOffset() + "]";
    }
}

