/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.PolicyUtils;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PrivilegeEscalationVector;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.Policy;
import org.sonar.iac.common.yaml.tree.SequenceTree;

@Rule(key="S6317")
public class PrivilegeEscalationCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "This policy is vulnerable to the \"%s\" privilege escalation vector. Remove permissions or restrict the set of resources they apply to.";
    private static final String MESSAGE_ACTION_MULTIPLE = "When combined with others, this permission enables the \"%s\" escalation vector.";
    private static final String MESSAGE_ACTION_SINGLE = "This permission enables the \"%s\" escalation vector.";
    private static final String MESSAGE_STATEMENT_ALL = "Permissions are granted on all resources.";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!resource.isType("AWS::IAM::ManagedPolicy")) {
            return;
        }
        PolicyUtils.getPolicies(resource.properties()).forEach(policy -> PrivilegeEscalationCheck.checkPrivilegeEscalation(ctx, policy, resource));
    }

    private static void checkPrivilegeEscalation(CheckContext ctx, Policy policy, AbstractResourceCheck.Resource resource) {
        for (Policy.Statement statement : policy.statement()) {
            Optional<Tree> action = statement.action();
            if (!action.isPresent() || !(action.get() instanceof SequenceTree)) continue;
            List<Tree> actionTrees = ((SequenceTree)action.get()).elements().stream().map(Tree.class::cast).collect(Collectors.toList());
            Optional<PrivilegeEscalationVector> vectorOpt = PrivilegeEscalationVector.getStatementEscalationVector(statement, actionTrees);
            if (!vectorOpt.isPresent()) continue;
            PrivilegeEscalationVector vector = vectorOpt.get();
            List<SecondaryLocation> secondaryLocations = PrivilegeEscalationCheck.secondaryLocations(statement, vector);
            ctx.reportIssue((HasTextRange)resource.type(), String.format(MESSAGE, vector.getName()), secondaryLocations);
        }
    }

    private static List<SecondaryLocation> secondaryLocations(Policy.Statement statement, PrivilegeEscalationVector vector) {
        ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
        secondaryLocations.addAll(PrivilegeEscalationCheck.retrieveSecondaryLocationsFromAction(statement, vector));
        secondaryLocations.addAll(PrivilegeEscalationCheck.retrieveSecondaryLocationsFromResource(statement));
        return secondaryLocations;
    }

    private static List<SecondaryLocation> retrieveSecondaryLocationsFromAction(Policy.Statement statement, PrivilegeEscalationVector vector) {
        ArrayList<SecondaryLocation> secondaryLocationsFromAction = new ArrayList<SecondaryLocation>();
        String actionsMsg = vector.getPermissions().size() == 1 ? String.format(MESSAGE_ACTION_SINGLE, vector.getName()) : String.format(MESSAGE_ACTION_MULTIPLE, vector.getName());
        statement.action().ifPresent(tree -> ((SequenceTree)tree).elements().stream().filter(actionElement -> TextUtils.getValue(actionElement).map(value -> PrivilegeEscalationVector.actionEnablesVector(vector, value)).orElse(false)).forEach(actionElement -> secondaryLocationsFromAction.add(new SecondaryLocation((HasTextRange)actionElement, actionsMsg))));
        return secondaryLocationsFromAction;
    }

    private static List<SecondaryLocation> retrieveSecondaryLocationsFromResource(Policy.Statement statement) {
        ArrayList<SecondaryLocation> secondaryLocationsFromResource = new ArrayList<SecondaryLocation>();
        statement.resource().ifPresent(resource -> {
            if (TextUtils.isValue(resource, "*").isTrue()) {
                secondaryLocationsFromResource.add(new SecondaryLocation((HasTextRange)resource, MESSAGE_STATEMENT_ALL));
            }
        });
        return secondaryLocationsFromResource;
    }
}

