/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.bicep;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.tree.ArmHelper;
import org.sonar.iac.arm.tree.BicepTypeExpressionResolution;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.NumericLiteral;
import org.sonar.iac.arm.tree.api.ParameterDeclaration;
import org.sonar.iac.arm.tree.api.ParameterType;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.api.bicep.Decorator;
import org.sonar.iac.arm.tree.api.bicep.HasDecorators;
import org.sonar.iac.arm.tree.api.bicep.HasKeyword;
import org.sonar.iac.arm.tree.api.bicep.InterpolatedString;
import org.sonar.iac.arm.tree.api.bicep.StringComplete;
import org.sonar.iac.arm.tree.api.bicep.SyntaxToken;
import org.sonar.iac.arm.tree.api.bicep.TypeExpressionAble;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.api.tree.Tree;

public class ParameterDeclarationImpl
extends AbstractArmTreeImpl
implements ParameterDeclaration,
HasDecorators,
HasKeyword {
    private final List<Decorator> decorators;
    private final SyntaxToken keyword;
    private final Identifier name;
    @Nullable
    private final TypeExpressionAble typeExpression;
    @Nullable
    private final SyntaxToken resource;
    @Nullable
    private final InterpolatedString typeInterp;
    @Nullable
    private final SyntaxToken equ;
    @Nullable
    private final Expression defaultValue;

    public ParameterDeclarationImpl(List<Decorator> decorators, SyntaxToken keyword, Identifier name, @Nullable TypeExpressionAble typeExpression, @Nullable SyntaxToken equ, @Nullable Expression defaultValue) {
        this.decorators = decorators;
        this.keyword = keyword;
        this.name = name;
        this.typeExpression = typeExpression;
        this.equ = equ;
        this.defaultValue = defaultValue;
        this.resource = null;
        this.typeInterp = null;
    }

    public ParameterDeclarationImpl(List<Decorator> decorators, SyntaxToken keyword, Identifier name, @Nullable SyntaxToken resource, @Nullable InterpolatedString typeInterp, @Nullable SyntaxToken equ, @Nullable Expression defaultValue) {
        this.decorators = decorators;
        this.keyword = keyword;
        this.name = name;
        this.resource = resource;
        this.typeInterp = typeInterp;
        this.equ = equ;
        this.defaultValue = defaultValue;
        this.typeExpression = null;
    }

    @Override
    public Identifier declaratedName() {
        return this.name;
    }

    @Override
    @CheckForNull
    public ParameterType type() {
        if (this.typeExpression != null) {
            ParameterType parameterType = ParameterType.fromName(BicepTypeExpressionResolution.resolve(this.typeExpression));
            if (this.findDecoratorByName("secure").isPresent()) {
                if (parameterType == ParameterType.STRING) {
                    return ParameterType.SECURE_STRING;
                }
                if (parameterType == ParameterType.OBJECT) {
                    return ParameterType.SECURE_OBJECT;
                }
            }
            return parameterType;
        }
        return null;
    }

    @Override
    @CheckForNull
    public TextTree resourceType() {
        return this.typeInterp;
    }

    @Override
    @CheckForNull
    public Expression defaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<Expression> allowedValues() {
        return this.findDecoratorByName("allowed").map(Decorator::functionCallOrMemberFunctionCall).map(d -> ((ArrayExpression)d.argumentList().elements().get(0)).elements()).orElse(Collections.emptyList());
    }

    @Override
    @CheckForNull
    public StringLiteral description() {
        return this.findDecoratorByName("description").map(Decorator::functionCallOrMemberFunctionCall).map(d -> d.argumentList().elements().get(0)).map(s -> ((StringComplete)s).content()).orElse(null);
    }

    @Override
    @CheckForNull
    public NumericLiteral minValue() {
        return this.findDecoratorByName("minValue").map(Decorator::functionCallOrMemberFunctionCall).map(d -> (NumericLiteral)d.argumentList().elements().get(0)).orElse(null);
    }

    @Override
    @CheckForNull
    public NumericLiteral maxValue() {
        return this.findDecoratorByName("maxValue").map(Decorator::functionCallOrMemberFunctionCall).map(d -> (NumericLiteral)d.argumentList().elements().get(0)).orElse(null);
    }

    @Override
    @CheckForNull
    public NumericLiteral minLength() {
        return this.findDecoratorByName("minLength").map(Decorator::functionCallOrMemberFunctionCall).map(d -> (NumericLiteral)d.argumentList().elements().get(0)).orElse(null);
    }

    @Override
    @CheckForNull
    public NumericLiteral maxLength() {
        return this.findDecoratorByName("maxLength").map(Decorator::functionCallOrMemberFunctionCall).map(d -> (NumericLiteral)d.argumentList().elements().get(0)).orElse(null);
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>(this.decorators);
        children.add((Decorator)((Object)this.keyword));
        children.add((Decorator)((Object)this.name));
        ArmHelper.addChildrenIfPresent(children, this.typeExpression);
        ArmHelper.addChildrenIfPresent(children, this.resource);
        ArmHelper.addChildrenIfPresent(children, this.typeInterp);
        ArmHelper.addChildrenIfPresent(children, this.equ);
        ArmHelper.addChildrenIfPresent(children, this.defaultValue);
        return children;
    }

    @Override
    public List<Decorator> decorators() {
        return this.decorators;
    }

    @Override
    public SyntaxToken keyword() {
        return this.keyword;
    }

    @CheckForNull
    public TypeExpressionAble typeExpression() {
        return this.typeExpression;
    }
}

