/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.bicep;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.tree.ArmHelper;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.OutputDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.api.bicep.Decorator;
import org.sonar.iac.arm.tree.api.bicep.HasDecorators;
import org.sonar.iac.arm.tree.api.bicep.HasKeyword;
import org.sonar.iac.arm.tree.api.bicep.InterpolatedString;
import org.sonar.iac.arm.tree.api.bicep.SyntaxToken;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.Tree;

public class OutputDeclarationImpl
extends AbstractArmTreeImpl
implements OutputDeclaration,
HasDecorators,
HasKeyword {
    private final List<Decorator> decorators;
    private final SyntaxToken keyword;
    private final Identifier name;
    @Nullable
    private final Identifier identifierType;
    @Nullable
    private final SyntaxToken resource;
    @Nullable
    private final InterpolatedString interpType;
    private final SyntaxToken equ;
    private final Expression expression;

    public OutputDeclarationImpl(List<Decorator> decorators, SyntaxToken keyword, Identifier name, Identifier identifierType, SyntaxToken equ, Expression expression) {
        this.decorators = decorators;
        this.keyword = keyword;
        this.name = name;
        this.identifierType = identifierType;
        this.equ = equ;
        this.expression = expression;
        this.resource = null;
        this.interpType = null;
    }

    public OutputDeclarationImpl(List<Decorator> decorators, SyntaxToken keyword, Identifier name, SyntaxToken resource, InterpolatedString interpType, SyntaxToken equ, Expression expression) {
        this.decorators = decorators;
        this.keyword = keyword;
        this.name = name;
        this.resource = resource;
        this.interpType = interpType;
        this.equ = equ;
        this.expression = expression;
        this.identifierType = null;
    }

    @Override
    public Identifier declaratedName() {
        return this.name;
    }

    @Override
    public ArmTree type() {
        if (this.identifierType != null) {
            return this.identifierType;
        }
        return this.interpType;
    }

    @Override
    @CheckForNull
    public StringLiteral condition() {
        return null;
    }

    @Override
    @CheckForNull
    public StringLiteral copyCount() {
        return null;
    }

    @Override
    @CheckForNull
    public Expression copyInput() {
        return null;
    }

    @Override
    @CheckForNull
    public Expression value() {
        return this.expression;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>(this.decorators);
        children.add((Decorator)((Object)this.keyword));
        children.add((Decorator)((Object)this.name));
        ArmHelper.addChildrenIfPresent(children, this.identifierType);
        ArmHelper.addChildrenIfPresent(children, this.resource);
        ArmHelper.addChildrenIfPresent(children, this.interpType);
        children.add(this.equ);
        children.add(this.expression);
        return children;
    }

    @Override
    public List<Decorator> decorators() {
        return this.decorators;
    }

    @Override
    public SyntaxToken keyword() {
        return this.keyword;
    }
}

