/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.parser.bicep;

import com.sonar.sslr.api.GenericTokenType;
import java.util.Arrays;
import java.util.stream.Stream;
import org.sonar.iac.arm.parser.bicep.BicepKeyword;
import org.sonar.iac.common.parser.grammar.Punctuator;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;

public enum BicepLexicalGrammar implements GrammarRuleKey
{
    EOF,
    EXCLAMATION_SIGN_ALONE,
    SPACING,
    EOL,
    FILE,
    STATEMENT,
    TYPE_DECLARATION,
    OUTPUT_DECLARATION,
    TARGET_SCOPE_DECLARATION,
    PARAMETER_DECLARATION,
    FUNCTION_DECLARATION,
    METADATA_DECLARATION,
    VARIABLE_DECLARATION,
    RESOURCE_DECLARATION,
    IMPORT_DECLARATION,
    MODULE_DECLARATION,
    PRIMARY_EXPRESSION,
    FUNCTION_CALL,
    IDENTIFIER,
    PROPERTY,
    OBJECT_EXPRESSION,
    FOR_EXPRESSION,
    FOR_VARIABLE_BLOCK,
    TYPE_EXPRESSION,
    SINGULAR_TYPE_EXPRESSION,
    PRIMARY_TYPE_EXPRESSION,
    PARENTHESIZED_TYPE_EXPRESSION,
    OBJECT_TYPE,
    OBJECT_TYPE_PROPERTY,
    AMBIENT_TYPE_REFERENCE,
    IF_CONDITION,
    EXPRESSION,
    BINARY_EXPRESSION,
    EQUALITY_EXPRESSION,
    RELATIONAL_EXPRESSION,
    ADDITIVE_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    UNARY_EXPRESSION,
    MEMBER_EXPRESSION,
    PARENTHESIZED_EXPRESSION,
    UNARY_OPERATOR_LITERAL_VALUE,
    UNARY_OPERATOR,
    ARRAY_EXPRESSION,
    LITERAL_VALUE,
    INTERPOLATED_STRING,
    STRING_COMPLETE,
    QUOTED_STRING_LITERAL,
    IDENTIFIER_LITERAL,
    STRING_LITERAL,
    MULTILINE_STRING,
    MULTILINE_STRING_VALUE,
    NUMBER_LITERAL,
    NUMERIC_LITERAL,
    BOOLEAN_LITERAL,
    TRUE_LITERAL,
    FALSE_LITERAL,
    NULL_LITERAL,
    LITERAL_VALUE_REGEX,
    NUMERIC_LITERAL_VALUE,
    TRUE_LITERAL_VALUE,
    FALSE_LITERAL_VALUE,
    NULL_LITERAL_VALUE,
    IMPORT_AS_CLAUSE,
    IMPORT_WITH_CLAUSE,
    AMBIENT_TYPE_REFERENCE_VALUE,
    UNARY_OPERATOR_VALUE,
    TUPLE_TYPE,
    TUPLE_ITEM,
    DECORATOR,
    TYPED_LOCAL_VARIABLE,
    TYPED_VARIABLE_BLOCK,
    TYPED_LAMBDA_EXPRESSION,
    LOCAL_VARIABLE,
    VARIABLE_BLOCK,
    LAMBDA_EXPRESSION;


    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        BicepLexicalGrammar.lexical(b);
        BicepLexicalGrammar.punctuators(b);
        BicepLexicalGrammar.keywords(b);
        return b;
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        Stream.of(Punctuator.values()).forEach(p -> b.rule((GrammarRuleKey)p).is(SPACING, p.getValue()).skip());
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule(EOL).is(b.regexp("(?:(?:\\r\\n|[\\n\\r\\u2028\\u2029])|$)"));
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule(SPACING).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), b.zeroOrMore(b.commentTrivia(b.regexp("(?://(?:[^\\n\\r])*+|#(?:[^\\n\\r])*+|/\\*[\\s\\S]*?\\*/)")), b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")))).skip();
        b.rule(EXCLAMATION_SIGN_ALONE).is(SPACING, b.regexp("!(?!=)"));
        b.rule(IDENTIFIER_LITERAL).is(SPACING, b.regexp("[a-zA-Z_][a-zA-Z_0-9]*+"));
        b.rule(QUOTED_STRING_LITERAL).is(SPACING, b.regexp("(?:(?!\\$\\{)(?:\\\\[\\S]|[^']))*+"));
        b.rule(MULTILINE_STRING_VALUE).is(SPACING, b.regexp("(?:(?!''')(?:[\\s\\S])?+)*+"));
        b.rule(NUMERIC_LITERAL_VALUE).is(SPACING, b.regexp("[0-9]++"));
        b.rule(TRUE_LITERAL_VALUE).is(SPACING, b.regexp("true"));
        b.rule(FALSE_LITERAL_VALUE).is(SPACING, b.regexp("false"));
        b.rule(NULL_LITERAL_VALUE).is(SPACING, b.regexp("null"));
        b.rule(AMBIENT_TYPE_REFERENCE_VALUE).is(SPACING, b.regexp("(?:array|bool|int|object|string)(?=\\s|\\)|,|\\z)"));
        b.rule(UNARY_OPERATOR_VALUE).is(SPACING, b.regexp("!|-|\\+"));
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        Arrays.stream(BicepKeyword.values()).forEach(tokenType -> b.rule((GrammarRuleKey)tokenType).is(SPACING, tokenType.getValue()).skip());
    }
}

