/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.parser;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.arm.parser.ArmJsonBaseConverter;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.ObjectExpression;
import org.sonar.iac.arm.tree.api.OutputDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.impl.json.OutputDeclarationImpl;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.TupleTree;

public class OutputDeclarationConverter
extends ArmJsonBaseConverter {
    public OutputDeclarationConverter(@Nullable InputFileContext inputFileContext) {
        super(inputFileContext);
    }

    public Stream<TupleTree> extractOutputsMapping(MappingTree document) {
        return this.extractMappingToTupleTreeOnField(document, "outputs");
    }

    public OutputDeclaration convertOutputDeclaration(TupleTree tree) {
        Identifier name = this.toIdentifier(tree.key());
        StringLiteral type = this.toStringLiteralOrException(tree.value(), "type");
        StringLiteral condition = this.toStringLiteralOrNull(tree.value(), "condition");
        Expression value = this.toExpressionOrNull(tree, "value");
        Expression copy = this.toExpressionOrNull(tree, "copy");
        if (copy instanceof ObjectExpression) {
            StringLiteral copyCount = PropertyUtils.value(copy, "count", StringLiteral.class).orElse(null);
            Expression copyInput = PropertyUtils.value(copy, "input", Expression.class).orElse(null);
            return new OutputDeclarationImpl(name, type, condition, copyCount, copyInput, value);
        }
        return new OutputDeclarationImpl(name, type, condition, null, null, value);
    }
}

