/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.List;
import java.util.function.Consumer;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S4423")
public class TlsVersionCheck
extends AbstractArmResourceCheck {
    private static final String TLS_VERSION_NOT_SET_MESSAGE = "Set minimumTlsVersion/minimalTlsVersion to disable support of older TLS versions.";
    private static final String TLS_VERSION_INCORRECT_MESSAGE = "Change this code to disable support of older TLS versions.";
    private static final String STORAGE_ACCOUNT_TLS_PROPERTY_KEY = "minimumTlsVersion";
    private static final String DATABASE_TLS_PROPERTY_KEY = "minimalTlsVersion";
    private static final List<String> DATABASE_RESOURCE_TYPES = List.of("Microsoft.DBforMySQL/servers", "Microsoft.DBforPostgreSQL/servers", "Microsoft.DBforMariaDB/servers");

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Storage/storageAccounts", TlsVersionCheck.checkTlsVersion(STORAGE_ACCOUNT_TLS_PROPERTY_KEY));
        this.register(DATABASE_RESOURCE_TYPES, TlsVersionCheck.checkTlsVersion(DATABASE_TLS_PROPERTY_KEY));
    }

    private static Consumer<ContextualResource> checkTlsVersion(String propertyName) {
        return resource -> ((ContextualProperty)resource.property(propertyName).reportIfAbsent(TLS_VERSION_NOT_SET_MESSAGE, new SecondaryLocation[0])).reportIf(expr -> TextUtils.isValue(expr, "TLS1_2").isFalse(), TLS_VERSION_INCORRECT_MESSAGE, new SecondaryLocation[0]);
    }
}

