/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.arm.checkdsl.ContextualMap;
import org.sonar.iac.arm.checkdsl.ContextualObject;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.NumericLiteral;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6364")
public class ShortBackupRetentionCheck
extends AbstractArmResourceCheck {
    private static final String RETENTION_PERIOD_TOO_SHORT_MESSAGE = "Make sure that defining a short backup retention duration is safe here.";
    private static final String NO_RETENTION_PERIOD_PROPERTY_MESSAGE = "Omitting \"%s\" causes a short backup retention period to be set. Make sure that defining a short backup retention duration is safe here.";
    private static final Set<String> TYPES_BASIC_RETENTION = Set.of("AzureIaasVM", "AzureSql", "AzureStorage", "MAB");
    private static final Set<String> TYPES_SUBPROTECTION_RETENTION = Set.of("GenericProtectionPolicy", "AzureWorkload");
    private static final Map<String, Function<Double, Double>> POLICY_TO_DAYS = Map.of("Days", days -> days, "Weeks", days -> days * 7.0, "Months", days -> days * 30.0, "Years", days -> days * 365.0);
    private static final int DEFAULT_RETENTION_PERIOD = 30;
    @RuleProperty(key="backup_retention_duration", defaultValue="30", description="Default minimum retention period in days.")
    public int retentionPeriodInDays = 30;

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Web/sites/config", this::checkBackupRetentionWebSitesConfig);
        this.register("Microsoft.DocumentDB/databaseAccounts", this::checkBackupRetentionDatabaseAccounts);
        this.register("Microsoft.RecoveryServices/vaults/backupPolicies", this::checkBackupRetentionRecoveryServicesVaults);
    }

    private void checkBackupRetentionWebSitesConfig(ContextualResource resource) {
        resource.object("backupSchedule").property("retentionPeriodInDays").reportIf(ShortBackupRetentionCheck.isNumericValue(backupRetentionIntervalInDays -> backupRetentionIntervalInDays < (double)this.retentionPeriodInDays), RETENTION_PERIOD_TOO_SHORT_MESSAGE, new SecondaryLocation[0]);
    }

    private void checkBackupRetentionDatabaseAccounts(ContextualResource resource) {
        ContextualObject backupPolicy = resource.object("backupPolicy");
        if (backupPolicy.property("type").is(CheckUtils.isEqual("Periodic"))) {
            ((ContextualProperty)((ContextualMap)backupPolicy.object("periodicModeProperties").reportIfAbsent(String.format(NO_RETENTION_PERIOD_PROPERTY_MESSAGE, "periodicModeProperties.backupRetentionIntervalInHours"), new SecondaryLocation[0])).property("backupRetentionIntervalInHours").reportIf(ShortBackupRetentionCheck.isNumericValue(backupRetentionIntervalInHours -> backupRetentionIntervalInHours / 24.0 < (double)this.retentionPeriodInDays), RETENTION_PERIOD_TOO_SHORT_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(NO_RETENTION_PERIOD_PROPERTY_MESSAGE, new SecondaryLocation[0]);
        }
    }

    private void checkBackupRetentionRecoveryServicesVaults(ContextualResource resource) {
        ShortBackupRetentionCheck.retrieveRetentionPolicy(resource).forEach(retentionPolicyObject -> {
            ContextualObject retentionDurationObject = ShortBackupRetentionCheck.retrieveRetentionDuration(retentionPolicyObject);
            Double durationInDays = ShortBackupRetentionCheck.computeRetentionInDays(retentionDurationObject);
            if (durationInDays != null && durationInDays < (double)this.retentionPeriodInDays) {
                retentionDurationObject.property("count").report(RETENTION_PERIOD_TOO_SHORT_MESSAGE, retentionDurationObject.property("durationType").toSecondary("Duration type"));
            }
        });
    }

    private static Stream<ContextualObject> retrieveRetentionPolicy(ContextualResource resource) {
        ContextualProperty backupManagementType = resource.property("backupManagementType");
        if (backupManagementType.is(CheckUtils.isValue(TYPES_BASIC_RETENTION::contains))) {
            return Stream.of(resource.object("retentionPolicy"));
        }
        if (backupManagementType.is(CheckUtils.isValue(TYPES_SUBPROTECTION_RETENTION::contains))) {
            return resource.list("subProtectionPolicy").objects().map(contextualObject -> contextualObject.object("retentionPolicy"));
        }
        return Stream.empty();
    }

    private static ContextualObject retrieveRetentionDuration(ContextualObject retentionPolicyObject) {
        ContextualProperty retentionPolicyType = retentionPolicyObject.property("retentionPolicyType");
        if (retentionPolicyType.is(CheckUtils.isEqual("SimpleRetentionPolicy"))) {
            return retentionPolicyObject.object("retentionDuration");
        }
        if (retentionPolicyType.is(CheckUtils.isEqual("LongTermRetentionPolicy"))) {
            return retentionPolicyObject.object("dailySchedule").object("retentionDuration");
        }
        return ContextualObject.fromAbsent(retentionPolicyObject.ctx, null, retentionPolicyObject);
    }

    @CheckForNull
    private static Double computeRetentionInDays(ContextualObject retentionPolicyObject) {
        Double count = ShortBackupRetentionCheck.propertyValueAsDoubleOrNull(retentionPolicyObject.property((String)"count").tree);
        String durationType = ShortBackupRetentionCheck.propertyValueAsStringOrNull(retentionPolicyObject.property((String)"durationType").tree);
        if (count != null && durationType != null) {
            return POLICY_TO_DAYS.getOrDefault(durationType, val -> null).apply(count);
        }
        return null;
    }

    private static Predicate<Expression> isNumericValue(DoublePredicate predicate) {
        return expr -> {
            Double value = CheckUtils.asNumericValueOrNull(expr);
            return value != null && predicate.test(value);
        };
    }

    @CheckForNull
    private static Double propertyValueAsDoubleOrNull(@Nullable Tree tree) {
        return Optional.ofNullable(tree).map(Property.class::cast).map(Property::value).filter(expr -> expr.is(ArmTree.Kind.NUMERIC_LITERAL)).map(expr -> ((NumericLiteral)expr).asDouble()).orElse(null);
    }

    @CheckForNull
    private static String propertyValueAsStringOrNull(@Nullable Tree tree) {
        return Optional.ofNullable(tree).map(Property.class::cast).map(Property::value).filter(expr -> expr.is(ArmTree.Kind.STRING_LITERAL, ArmTree.Kind.STRING_COMPLETE)).flatMap(TextUtils::getValue).orElse(null);
    }
}

