/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6379")
public class ResourceSpecificAdminAccountCheck
extends AbstractArmResourceCheck {
    private static final String MESSAGE = "Make sure that enabling an administrative account or administrative permissions is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Batch/batchAccounts/pools", ResourceSpecificAdminAccountCheck::checkBatchAccountsPools);
        this.register("Microsoft.ContainerRegistry/registries", ResourceSpecificAdminAccountCheck::checkContainerRegistryRegistries);
    }

    private static void checkBatchAccountsPools(ContextualResource contextualResource) {
        contextualResource.objectsByPath("startTask/userIdentity/autoUser").forEach(autoUser -> autoUser.property("elevationLevel").reportIf(expression -> TextUtils.isValue(expression, "Admin").isTrue(), MESSAGE, new SecondaryLocation[0]));
    }

    private static void checkContainerRegistryRegistries(ContextualResource contextualResource) {
        contextualResource.property("adminUserEnabled").reportIf(CheckUtils.isTrue(), MESSAGE, new SecondaryLocation[0]);
    }
}

